/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundTracker;
import com.example.soundattract.StealthDetectionEvents;
import com.example.soundattract.config.SoundAttractConfig;
import com.tacz.guns.api.event.common.GunReloadEvent;
import com.tacz.guns.api.event.common.GunShootEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import org.apache.commons.lang3.tuple.Pair;

public class TaczIntegrationServerEvents {
    private static final String TACZ_SHOOT_SOUND_ID = "tacz:gun_shoot";
    private static final String TACZ_RELOAD_SOUND_ID = "tacz:gun_reload";

    @SubscribeEvent
    public static void onGunShoot(GunShootEvent event) {
        if (event.getLogicalSide() != LogicalSide.SERVER) {
            return;
        }
        LivingEntity shooter = event.getShooter();
        if (!(shooter instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)shooter;
        IGun iGun = IGun.getIGunOrNull((ItemStack)event.getGunItemStack());
        if (iGun != null) {
            double flashRange = (Double)SoundAttractConfig.COMMON.gunshotBaseDetectionRange.get();
            double reduction = 0.0;
            ResourceLocation muzzleId = iGun.getAttachmentId(event.getGunItemStack(), AttachmentType.MUZZLE);
            if (muzzleId != null) {
                reduction = SoundAttractConfig.TACZ_MUZZLE_FLASH_REDUCTION_CACHE.getOrDefault(muzzleId.toString(), 0.0);
            }
            double finalDetectionRange = Math.max(0.0, flashRange - reduction);
            StealthDetectionEvents.recordPlayerGunshot((Player)player, finalDetectionRange);
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[TaczIntegration] Gunshot Flash: BaseRange={}, Muzzle='{}', Reduction={}, FinalRange={}", new Object[]{String.format("%.2f", flashRange), muzzleId != null ? muzzleId.toString() : "None", String.format("%.2f", reduction), String.format("%.2f", finalDetectionRange)});
            }
        }
        double[] rangeAndWeight = TaczIntegrationServerEvents.calculateShootRangeWeight(event.getGunItemStack());
        double range = rangeAndWeight[0];
        double weight = rangeAndWeight[1];
        int lifetime = (Integer)SoundAttractConfig.COMMON.soundLifetimeTicks.get();
        SoundTracker.addSound(null, player.blockPosition(), player.level().dimension().location().toString(), range, weight, lifetime, TACZ_SHOOT_SOUND_ID);
    }

    @SubscribeEvent
    public static void onGunReload(GunReloadEvent event) {
        if (event.getLogicalSide() != LogicalSide.SERVER) {
            return;
        }
        LivingEntity reloader = event.getEntity();
        if (!(reloader instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)reloader;
        double[] rangeAndWeight = TaczIntegrationServerEvents.calculateReloadRangeWeight(event.getGunItemStack());
        double range = rangeAndWeight[0];
        double weight = rangeAndWeight[1];
        int lifetime = (Integer)SoundAttractConfig.COMMON.soundLifetimeTicks.get();
        SoundTracker.addSound(null, player.blockPosition(), player.level().dimension().location().toString(), range, weight, lifetime, TACZ_RELOAD_SOUND_ID);
    }

    private static double[] calculateShootRangeWeight(ItemStack gunStack) {
        IGun iGun = IGun.getIGunOrNull((ItemStack)gunStack);
        double finalRange = SoundAttractConfig.TACZ_SHOOT_RANGE_CACHE;
        if (iGun != null) {
            Pair<Double, Double> attachmentStats;
            ResourceLocation gunId = iGun.getGunId(gunStack);
            ResourceLocation attId = iGun.getAttachmentId(gunStack, AttachmentType.MUZZLE);
            Pair<Double, Double> gunStats = SoundAttractConfig.TACZ_GUN_SHOOT_DB_CACHE.get(gunId.toString());
            double gunRange = gunStats != null ? (Double)gunStats.getLeft() : SoundAttractConfig.TACZ_SHOOT_RANGE_CACHE;
            double reduction = 0.0;
            if (attId != null && (attachmentStats = SoundAttractConfig.TACZ_ATTACHMENT_REDUCTION_DB_CACHE.get(attId.toString())) != null) {
                reduction = (Double)attachmentStats.getRight();
            }
            finalRange = Math.max(0.0, gunRange - reduction);
        }
        double weight = finalRange / 10.0;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[TaczIntegration] Shot: range={}, weight={}", (Object)String.format("%.2f", finalRange), (Object)String.format("%.2f", weight));
        }
        return new double[]{finalRange, weight};
    }

    private static double[] calculateReloadRangeWeight(ItemStack gunStack) {
        double range = SoundAttractConfig.TACZ_RELOAD_RANGE_CACHE;
        double weight = SoundAttractConfig.TACZ_RELOAD_WEIGHT_CACHE;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[TaczIntegration] Reload: range={}, weight={}", (Object)String.format("%.2f", range), (Object)String.format("%.2f", weight));
        }
        return new double[]{range, weight};
    }
}

