/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.loot;

import com.example.soundattract.enchantment.ModEnchantments;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class EnchantRandomToolModifier
extends LootModifier {
    public static final MapCodec<EnchantRandomToolModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> EnchantRandomToolModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, EnchantRandomToolModifier::new));

    public EnchantRandomToolModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Registry enchantmentRegistry = context.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Holder.Reference concealHolder = enchantmentRegistry.getHolderOrThrow(ModEnchantments.CONCEAL);
        for (ItemStack stack : generatedLoot) {
            if (stack.isEmpty() || !(stack.getItem() instanceof DiggerItem) && !(stack.getItem() instanceof SwordItem) || !((Enchantment)concealHolder.value()).canEnchant(stack) || EnchantmentHelper.getItemEnchantmentLevel((Holder)concealHolder, (ItemStack)stack) != 0) continue;
            stack.enchant((Holder)concealHolder, 1);
            return generatedLoot;
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

