/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.ai.AdaptiveScanScheduler;
import com.example.soundattract.ai.MobGroupManager;
import net.minecraft.class_3218;

public class DynamicScanCooldownManager {
    private static volatile double lastTps = 20.0;
    public static int currentScanCooldownTicks = SoundAttractMod.CONFIG != null ? SoundAttractMod.CONFIG.scanCooldownTicks : 20;
    private static final int DEFAULT_MAX_COOLDOWN = 60;
    private static final int MOBS_100_MAX_COOLDOWN = 100;
    private static final int MOBS_200_MAX_COOLDOWN = 150;
    private static final int MOBS_400_MAX_COOLDOWN = 200;
    private static final int MOBS_800_MAX_COOLDOWN = 300;
    private static final int MOBS_100_THRESHOLD = 100;
    private static final int MOBS_200_THRESHOLD = 200;
    private static final int MOBS_400_THRESHOLD = 400;
    private static final int MOBS_800_THRESHOLD = 800;
    private static long lastCheckTime = System.currentTimeMillis();
    private static long lastTickCount = 0L;
    private static final int[] DEFAULT_TIER_SHIFTS = new int[]{0, 1, 2, 3};
    public static AdaptiveScanScheduler scheduler = new AdaptiveScanScheduler(currentScanCooldownTicks, DEFAULT_TIER_SHIFTS);

    private static double getLowTps() {
        return SoundAttractMod.CONFIG.minTpsForScanCooldown;
    }

    private static double getHighTps() {
        return SoundAttractMod.CONFIG.maxTpsForScanCooldown;
    }

    public static void tickScheduler(class_3218 level, long currentTick) {
        scheduler.tick(currentTick, task -> MobGroupManager.updateCellGroup(task.cellKey, level));
    }

    public static void update(long totalTickCount, int mobCount) {
        long now = System.currentTimeMillis();
        long ticksElapsed = totalTickCount - lastTickCount;
        long timeElapsed = now - lastCheckTime;
        int maxCooldown = mobCount > 800 ? 300 : (mobCount > 400 ? 200 : (mobCount > 200 ? 150 : (mobCount > 100 ? 100 : 60)));
        if (ticksElapsed > 0L && timeElapsed > 0L) {
            int configuredCooldown;
            double tps = (double)ticksElapsed * 1000.0 / (double)timeElapsed * 20.0;
            lastTps = 0.8 * lastTps + 0.2 * tps;
            double lowTps = DynamicScanCooldownManager.getLowTps();
            double highTps = DynamicScanCooldownManager.getHighTps();
            int n = configuredCooldown = SoundAttractMod.CONFIG != null ? SoundAttractMod.CONFIG.scanCooldownTicks : currentScanCooldownTicks;
            if (tps < lowTps || mobCount > 100) {
                currentScanCooldownTicks = Math.min(maxCooldown, currentScanCooldownTicks + 2);
            } else if (tps > highTps && currentScanCooldownTicks > configuredCooldown) {
                currentScanCooldownTicks = Math.max(configuredCooldown, currentScanCooldownTicks - 1);
            }
        }
        lastCheckTime = now;
        lastTickCount = totalTickCount;
        if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[CooldownManager] cooldown={}, mobCount={}, tps={}", new Object[]{currentScanCooldownTicks, mobCount, lastTps});
        }
    }

    public static boolean shouldScanThisTick(long mobId, long totalTickCount) {
        return (mobId + totalTickCount) % (long)currentScanCooldownTicks == 0L;
    }

    public static int getGroupAssignmentInterval() {
        int base = currentScanCooldownTicks;
        double lowTps = DynamicScanCooldownManager.getLowTps();
        if (lastTps < lowTps) {
            return Math.max(1, base * 20);
        }
        return Math.max(1, base * 3);
    }
}

