/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundTracker;
import com.example.soundattract.config.SoundAttractConfigData;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class SoundMessage {
    private final class_2960 soundId;
    private final double x;
    private final double y;
    private final double z;
    private final class_2960 dimension;
    private final Optional<UUID> sourcePlayerUUID;
    private final int range;
    private final double weight;
    private final String animatorClass;
    private final String gunData;
    public static final class_2960 VOICE_CHAT_SOUND_ID = new class_2960("soundattract", "voice_chat");

    public SoundMessage(class_2960 soundId, double x, double y, double z, class_2960 dimension, Optional<UUID> sourcePlayerUUID, int range, double weight, String animatorClass, String gunData) {
        this.soundId = soundId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
        this.sourcePlayerUUID = sourcePlayerUUID;
        this.range = range;
        this.weight = weight;
        this.animatorClass = animatorClass;
        this.gunData = gunData;
    }

    public SoundMessage(class_2960 soundId, double x, double y, double z, class_2960 dimension, Optional<UUID> sourcePlayerUUID, int range, double weight, String animatorClass) {
        this(soundId, x, y, z, dimension, sourcePlayerUUID, range, weight, animatorClass, null);
    }

    public SoundMessage(class_2960 soundId, double x, double y, double z, class_2960 dimension, Optional<UUID> sourcePlayerUUID) {
        this(soundId, x, y, z, dimension, sourcePlayerUUID, -1, 1.0, null, null);
    }

    public SoundMessage(class_2960 soundId, double x, double y, double z, class_2960 dimension, Optional<UUID> sourcePlayerUUID, int range) {
        this(soundId, x, y, z, dimension, sourcePlayerUUID, range, 1.0, null, null);
    }

    public SoundMessage(class_2960 soundId, double x, double y, double z, class_2960 dimension, Optional<UUID> sourcePlayerUUID, int range, double weight) {
        this(soundId, x, y, z, dimension, sourcePlayerUUID, range, weight, null, null);
    }

    public static void encode(SoundMessage msg, class_2540 buf) {
        buf.method_10812(msg.soundId);
        buf.writeDouble(msg.x);
        buf.writeDouble(msg.y);
        buf.writeDouble(msg.z);
        buf.method_10812(msg.dimension);
        buf.writeBoolean(msg.sourcePlayerUUID.isPresent());
        msg.sourcePlayerUUID.ifPresent(arg_0 -> ((class_2540)buf).method_10797(arg_0));
        buf.writeInt(msg.range);
        buf.writeDouble(msg.weight);
        buf.writeBoolean(msg.animatorClass != null);
        if (msg.animatorClass != null) {
            buf.method_10814(msg.animatorClass);
        }
        buf.writeBoolean(msg.gunData != null);
        if (msg.gunData != null) {
            buf.method_10814(msg.gunData);
        }
    }

    public static SoundMessage decode(class_2540 buf) {
        class_2960 soundId = buf.method_10810();
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        class_2960 dimension = buf.method_10810();
        Optional<UUID> sourcePlayerUUID = buf.readBoolean() ? Optional.of(buf.method_10790()) : Optional.empty();
        int range = buf.readInt();
        double weight = buf.readDouble();
        String animatorClass = buf.readBoolean() ? buf.method_19772() : null;
        String gunData = buf.readBoolean() ? buf.method_19772() : null;
        return new SoundMessage(soundId, x, y, z, dimension, sourcePlayerUUID, range, weight, animatorClass, gunData);
    }

    public static void handle(SoundMessage msg, class_3222 sender) {
        if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[DEBUG] SoundMessage.handle called for soundId: {} | range: {} | weight: {} | pos: ({}, {}, {}) | dim: {} | sender: {}", new Object[]{msg.soundId, msg.range, msg.weight, msg.x, msg.y, msg.z, msg.dimension, sender != null ? sender.method_5477().getString() : "null"});
        }
        try {
            String soundIdStr;
            String string = soundIdStr = msg.soundId != null ? msg.soundId.toString() : null;
            if (!(SoundAttractMod.CONFIG.soundIdWhitelist.isEmpty() || soundIdStr != null && SoundAttractMod.CONFIG.soundIdWhitelist.contains(soundIdStr) || msg.soundId != null && msg.soundId.equals((Object)VOICE_CHAT_SOUND_ID))) {
                return;
            }
            if (sender == null) {
                SoundAttractMod.LOGGER.warn("[SoundMessage] sender is null for sound message with soundId: {}", (Object)msg.soundId);
                return;
            }
            class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)msg.dimension);
            class_3218 serverWorld = sender.method_5682().method_3847(worldKey);
            if (serverWorld == null) {
                SoundAttractMod.LOGGER.warn("[SoundMessage] serverWorld is null for dimension: {}", (Object)msg.dimension);
                return;
            }
            if (!serverWorld.method_27983().method_29177().equals((Object)msg.dimension)) {
                SoundAttractMod.LOGGER.warn("[SoundMessage] serverWorld dimension mismatch: {} != {}", (Object)serverWorld.method_27983().method_29177(), (Object)msg.dimension);
                return;
            }
            class_2338 pos = new class_2338((int)msg.x, (int)msg.y, (int)msg.z);
            if (pos.method_10263() == 0 && pos.method_10264() == 0 && pos.method_10260() == 0 && sender != null) {
                pos = sender.method_24515();
                SoundAttractMod.LOGGER.info("[SoundMessage] Fallback to sender position {} for sound {}", (Object)pos, (Object)msg.soundId);
            }
            String dimString = msg.dimension.toString();
            int lifetime = SoundAttractMod.CONFIG.soundLifetimeTicks;
            if (msg.gunData != null) {
                String actionType = "unknown";
                String gunId = "unknown";
                try {
                    String[] parts = msg.gunData.split(";", 2);
                    if (parts.length > 0) {
                        actionType = parts[0];
                    }
                    if (parts.length > 1) {
                        gunId = parts[1];
                    }
                }
                catch (Exception e) {
                    SoundAttractMod.LOGGER.warn("[SoundMessage] Failed to parse gunData string: {}", (Object)msg.gunData, (Object)e);
                }
                if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[DEBUG_SERVER] Received gun action SoundMessage: action={}, gunId={}, raw='{}'", new Object[]{actionType, gunId, msg.gunData});
                }
            }
            if (msg.soundId.equals((Object)VOICE_CHAT_SOUND_ID)) {
                if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[DEBUG] About to call SoundTracker.addSound for VOICE_CHAT_SOUND_ID at pos=({}, {}, {}), dim={}, range={}, weight={}", new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260(), dimString, msg.range, msg.weight});
                }
                if (msg.range > 0) {
                    SoundTracker.addSound(null, pos, dimString, msg.range, msg.weight, lifetime, VOICE_CHAT_SOUND_ID.toString());
                }
            } else {
                SoundAttractConfigData.SoundConfig config;
                double range = msg.range;
                double weight = msg.weight;
                if (range < 0.0 && msg.soundId != null && (config = SoundAttractMod.CONFIG.getSoundConfigForId(msg.soundId.toString())) != null) {
                    range = config.range;
                    weight = config.weight;
                    if (SoundAttractMod.CONFIG.debugLogging) {
                        SoundAttractMod.LOGGER.info("[SoundMessage] Overriding range/weight for {} from nonPlayerSoundIdList: range={}, weight={}", new Object[]{msg.soundId, range, weight});
                    }
                }
                SoundTracker.addSound(null, pos, dimString, range, weight, lifetime, msg.soundId.toString());
            }
        }
        catch (Exception e) {
            SoundAttractMod.LOGGER.error("[SoundMessage] Exception in handle for soundId={}", (Object)msg.soundId, (Object)e);
        }
    }
}

