/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.FovEvents;
import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundTracker;
import com.example.soundattract.StealthDetectionEvents;
import com.example.soundattract.StealthUtils;
import com.example.soundattract.ai.BlockBreakerManager;
import com.example.soundattract.ai.BlockBreakerPosGoal;
import com.example.soundattract.ai.MobGroupManager;
import com.example.soundattract.ai.RaidManager;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class FollowerEdgeRelayGoal
extends class_1352 {
    private final class_1308 mob;
    private final double moveSpeed;
    private EdgeState state = null;
    private SoundTracker.SoundRecord cachedSound;
    private class_2338 targetPos;
    private boolean foundPlayerOrHit;
    private boolean relayed;
    private int arrivalTicks;
    private int pursueTicksRemaining;
    private class_1308 cachedLeader = null;
    private class_2338 lastIssuedNavTarget = null;
    private int repathCooldown = 0;
    private static final int REPATH_COOLDOWN_TICKS = 6;
    private class_243 lastPosVec = null;
    private int stuckTicks = 0;
    private BlockBreakerPosGoal blockBreakerGoal = null;
    private int debugTick = 0;

    public FollowerEdgeRelayGoal(class_1308 mob, double moveSpeed) {
        this.mob = mob;
        this.moveSpeed = moveSpeed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        if (this.mob.method_5765() || this.mob.method_6113() || this.mob.method_5968() != null) {
            return false;
        }
        if (MobGroupManager.getLeader(this.mob) == this.mob) {
            return false;
        }
        boolean isEdge = MobGroupManager.isEdgeMobEntity(this.mob);
        boolean isDeserter = MobGroupManager.isDeserter(this.mob);
        if (!isEdge && !isDeserter) {
            return false;
        }
        class_1937 world = this.mob.method_37908();
        if (world.method_8608()) {
            return false;
        }
        SoundTracker.SoundRecord best = SoundTracker.getCachedBestFor(this.mob, world.method_27983().method_29177().toString());
        if (best == null) {
            try {
                SoundTracker.submitAsyncSoundScore(world, this.mob, this.mob.method_24515());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            best = SoundTracker.findNearestSound(world, this.mob, this.mob.method_24515(), this.mob.method_33571());
        }
        if (best == null) {
            return false;
        }
        this.cachedSound = best;
        this.targetPos = best.pos;
        this.state = EdgeState.GOING_TO_SOUND;
        this.foundPlayerOrHit = false;
        this.relayed = false;
        this.arrivalTicks = 0;
        this.pursueTicksRemaining = Math.max(best.ticksRemaining, SoundAttractMod.CONFIG != null ? SoundAttractMod.CONFIG.scanCooldownTicks * 2 : 40);
        class_1308 l = MobGroupManager.getLeader(this.mob);
        class_1308 class_13082 = this.cachedLeader = l != null && l != this.mob ? l : null;
        if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} investigating sound {} at {} (w={})", new Object[]{this.mob.method_5477().getString(), String.valueOf(best.soundId), best.pos, String.format("%.2f", best.weight)});
        }
        return true;
    }

    public boolean method_6266() {
        if (this.state == null) {
            return false;
        }
        if (this.state == EdgeState.RETURNING_TO_LEADER) {
            class_1308 leader = this.getSafeLeader();
            return leader != null && leader != this.mob && leader.method_5805();
        }
        if (MobGroupManager.getLeader(this.mob) == this.mob) {
            return false;
        }
        return this.pursueTicksRemaining > 0 || this.state != EdgeState.GOING_TO_SOUND;
    }

    public void method_6270() {
        this.mob.method_5942().method_6340();
        if (this.blockBreakerGoal != null) {
            BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
            this.blockBreakerGoal = null;
        }
        this.state = null;
        this.cachedSound = null;
        this.targetPos = null;
        this.foundPlayerOrHit = false;
        this.relayed = false;
        this.arrivalTicks = 0;
        this.pursueTicksRemaining = 0;
        this.lastIssuedNavTarget = null;
        this.repathCooldown = 0;
        this.lastPosVec = null;
        this.stuckTicks = 0;
        this.debugTick = 0;
        this.cachedLeader = null;
    }

    public void method_6268() {
        if (this.pursueTicksRemaining > 0) {
            --this.pursueTicksRemaining;
        }
        if (this.state == EdgeState.GOING_TO_SOUND) {
            double arrival;
            Object breaker;
            class_2338 destination;
            if (this.targetPos == null) {
                this.state = EdgeState.RETURNING_TO_LEADER;
                return;
            }
            this.moveToThrottled(this.targetPos, this.moveSpeed, false);
            class_243 cur = this.mob.method_19538();
            if (this.lastPosVec != null && cur.method_1025(this.lastPosVec) < 0.01) {
                ++this.stuckTicks;
            } else {
                this.stuckTicks = 0;
                this.lastPosVec = cur;
                if (this.blockBreakerGoal != null) {
                    BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                    this.blockBreakerGoal = null;
                }
            }
            if (this.stuckTicks >= 40 && SoundAttractMod.CONFIG.enableBlockBreaking && this.blockBreakerGoal == null && (destination = this.targetPos) != null) {
                breaker = new BlockBreakerPosGoal(this.mob, destination, SoundAttractMod.CONFIG.blockBreakTimeMultiplier, SoundAttractMod.CONFIG.blockBreakToolOnly, SoundAttractMod.CONFIG.blockBreakProperToolOnly, SoundAttractMod.CONFIG.blockBreakProperToolRequired);
                BlockBreakerManager.scheduleAdd(this.mob, (class_1352)breaker, 2);
                this.blockBreakerGoal = breaker;
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} stuck ({} ticks). Deploying BlockBreakerPosGoal toward {}.", new Object[]{this.mob.method_5477().getString(), this.stuckTicks, destination});
                }
            }
            if (StealthDetectionEvents.consumeSuppressedEdgeDetection(this.mob)) {
                this.foundPlayerOrHit = true;
                if (!this.relayed && this.targetPos != null && (breaker = this.mob.method_37908()) instanceof class_3218) {
                    class_3218 sw = (class_3218)breaker;
                    class_1308 leader = this.getSafeLeader();
                    if (leader != null && leader != this.mob) {
                        RaidManager.scheduleRaid(leader, this.targetPos, sw.method_8510());
                        this.relayed = true;
                        if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                            SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} consumed suppression signal \u2192 scheduled RAID for leader {} at {}.", new Object[]{this.mob.method_5477().getString(), leader.method_5477().getString(), this.targetPos});
                        }
                    }
                }
                if (this.blockBreakerGoal != null) {
                    BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                    this.blockBreakerGoal = null;
                }
                StealthUtils.clearTargetAndMemories(this.mob);
                this.mob.method_5942().method_6340();
                this.state = EdgeState.RETURNING_TO_LEADER;
                return;
            }
            double d = arrival = SoundAttractMod.CONFIG != null ? SoundAttractMod.CONFIG.arrivalDistance : 6.0;
            if (this.mob.method_19538().method_1022(class_243.method_24953((class_2382)this.targetPos)) < arrival) {
                int waitTicks;
                ++this.arrivalTicks;
                this.mob.method_5942().method_6340();
                double maxRange = (SoundAttractMod.CONFIG != null ? SoundAttractMod.CONFIG.standingDetectionRange : 16.0) * 2.0;
                class_238 box = new class_238(this.targetPos).method_1014(maxRange);
                List players = this.mob.method_37908().method_8390(class_1657.class, box, class_1309::method_5805);
                for (class_1657 p : players) {
                    if (p.method_7337() || p.method_7325() || !FovEvents.hasSmartLineOfSight(this.mob, (class_1297)p)) continue;
                    double detectRange = StealthDetectionEvents.computeFullDetectionRange(this.mob, p, this.mob.method_37908());
                    if (!((double)p.method_5739((class_1297)this.mob) <= detectRange)) continue;
                    this.foundPlayerOrHit = true;
                    if (SoundAttractMod.CONFIG == null || !SoundAttractMod.CONFIG.debugLogging) break;
                    SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} found player {} at {}. Returning to leader.", new Object[]{this.mob.method_5477().getString(), p.method_5477().getString(), this.targetPos});
                    break;
                }
                int n = waitTicks = SoundAttractMod.CONFIG != null ? SoundAttractMod.CONFIG.edgeInvestigateWaitTicks : 15;
                if (this.foundPlayerOrHit || this.arrivalTicks >= waitTicks) {
                    class_1937 detectRange;
                    if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                        SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} investigation {}. Returning to leader.", (Object)this.mob.method_5477().getString(), (Object)(this.foundPlayerOrHit ? "SUCCESS (player detected)" : "finished (no player)"));
                    }
                    if (this.blockBreakerGoal != null) {
                        BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                        this.blockBreakerGoal = null;
                    }
                    if (MobGroupManager.isDeserter(this.mob)) {
                        if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                            SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} is a deserter; will NOT return after arrival. Ending goal.", (Object)this.mob.method_5477().getString());
                        }
                        this.method_6270();
                        return;
                    }
                    if (this.foundPlayerOrHit) {
                        StealthUtils.clearTargetAndMemories(this.mob);
                    }
                    if (this.foundPlayerOrHit && !this.relayed && this.targetPos != null && (detectRange = this.mob.method_37908()) instanceof class_3218) {
                        class_3218 sw = (class_3218)detectRange;
                        class_1308 leader = this.getSafeLeader();
                        if (leader != null && leader != this.mob) {
                            RaidManager.scheduleRaid(leader, this.targetPos, sw.method_8510());
                            this.relayed = true;
                            if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                                SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} scheduled RAID for leader {} at {} (arrival-phase).", new Object[]{this.mob.method_5477().getString(), leader.method_5477().getString(), this.targetPos});
                            }
                        }
                    }
                    this.state = EdgeState.RETURNING_TO_LEADER;
                }
            }
        } else if (this.state == EdgeState.RETURNING_TO_LEADER) {
            double arrival;
            class_1308 leader = this.getSafeLeader();
            if (leader == null || leader == this.mob || !leader.method_5805()) {
                this.method_6270();
                return;
            }
            double sprintMult = SoundAttractMod.CONFIG != null ? SoundAttractMod.CONFIG.groupSprintMultiplier : 1.1;
            this.moveToThrottled(leader.method_24515(), this.moveSpeed * sprintMult, false);
            class_243 curReturn = this.mob.method_19538();
            if (this.lastPosVec != null && curReturn.method_1025(this.lastPosVec) < 0.01) {
                ++this.stuckTicks;
            } else {
                this.stuckTicks = 0;
                this.lastPosVec = curReturn;
                if (this.blockBreakerGoal != null) {
                    BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                    this.blockBreakerGoal = null;
                }
            }
            if (this.stuckTicks >= 40 && SoundAttractMod.CONFIG.enableBlockBreaking && this.blockBreakerGoal == null) {
                BlockBreakerPosGoal breaker = new BlockBreakerPosGoal(this.mob, leader.method_24515(), SoundAttractMod.CONFIG.blockBreakTimeMultiplier, SoundAttractMod.CONFIG.blockBreakToolOnly, SoundAttractMod.CONFIG.blockBreakProperToolOnly, SoundAttractMod.CONFIG.blockBreakProperToolRequired);
                BlockBreakerManager.scheduleAdd(this.mob, breaker, 2);
                this.blockBreakerGoal = breaker;
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} stuck while returning ({} ticks). Deploying BlockBreakerPosGoal toward leader {} at {}.", new Object[]{this.mob.method_5477().getString(), this.stuckTicks, leader.method_5477().getString(), leader.method_24515()});
                }
            }
            if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging && this.debugTick++ % 20 == 0) {
                double dist = Math.sqrt(this.mob.method_19538().method_1025(leader.method_19538()));
                SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} returning to leader {}. dist={}. navIdle={}", new Object[]{this.mob.method_5477().getString(), leader.method_5477().getString(), String.format("%.1f", dist), this.mob.method_5942().method_6357()});
            }
            double d = arrival = SoundAttractMod.CONFIG != null ? SoundAttractMod.CONFIG.leaderReturnArrivalDistance : 2.0;
            if (this.mob.method_19538().method_1025(leader.method_19538()) < arrival * arrival) {
                if (this.foundPlayerOrHit && !this.relayed && this.targetPos != null && this.cachedSound != null) {
                    StealthUtils.clearTargetAndMemories(this.mob);
                    class_1937 class_19372 = this.mob.method_37908();
                    if (class_19372 instanceof class_3218) {
                        class_3218 sw = (class_3218)class_19372;
                        RaidManager.scheduleRaid(leader, this.targetPos, sw.method_8510());
                    }
                    this.relayed = true;
                    if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                        SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} confirmed player at {} \u2192 scheduled RAID for leader {} (no immediate relay).", new Object[]{this.mob.method_5477().getString(), this.targetPos, leader.method_5477().getString()});
                    }
                }
                this.method_6270();
            }
        }
    }

    private void navigateTo(class_2338 target, double speed) {
        if (target == null) {
            if (!this.mob.method_5942().method_6357()) {
                this.mob.method_5942().method_6340();
            }
            return;
        }
        this.mob.method_5942().method_6337((double)target.method_10263() + 0.5, (double)target.method_10264(), (double)target.method_10260() + 0.5, speed);
    }

    private void moveToThrottled(class_2338 dest, double speed, boolean force) {
        if (dest == null) {
            return;
        }
        if (force) {
            this.mob.method_5942().method_6337((double)dest.method_10263() + 0.5, (double)dest.method_10264(), (double)dest.method_10260() + 0.5, speed);
            this.lastIssuedNavTarget = dest;
            this.repathCooldown = 6;
            return;
        }
        boolean destChanged = this.lastIssuedNavTarget == null || !this.lastIssuedNavTarget.equals((Object)dest);
        boolean navIdle = this.mob.method_5942().method_6357();
        if (this.repathCooldown > 0 && !destChanged && !navIdle) {
            --this.repathCooldown;
            return;
        }
        double distSq = this.mob.method_19538().method_1028((double)dest.method_10263() + 0.5, (double)dest.method_10264(), (double)dest.method_10260() + 0.5);
        double thresholdSq = 4.0;
        if (destChanged || navIdle || distSq > thresholdSq) {
            this.mob.method_5942().method_6337((double)dest.method_10263() + 0.5, (double)dest.method_10264(), (double)dest.method_10260() + 0.5, speed);
            this.lastIssuedNavTarget = dest;
            this.repathCooldown = 6;
        }
    }

    private class_1308 getSafeLeader() {
        if (this.cachedLeader != null && this.cachedLeader.method_5805() && !this.cachedLeader.method_31481()) {
            return this.cachedLeader;
        }
        class_1308 l = MobGroupManager.getLeader(this.mob);
        if (l != null && l != this.mob && l.method_5805() && !l.method_31481()) {
            this.cachedLeader = l;
            return l;
        }
        return null;
    }

    private static enum EdgeState {
        GOING_TO_SOUND,
        RETURNING_TO_LEADER;

    }
}

