/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundTracker;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class PickUpAndThrowToSoundGoal
extends class_1352 {
    private final class_1308 mob;
    private class_1308 pickUp;
    private int unreachableTime;
    private int cooldown;
    private SoundTracker.SoundRecord targetSound;

    public PickUpAndThrowToSoundGoal(class_1308 mob) {
        this.mob = mob;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18408, class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (SoundAttractMod.CONFIG == null) {
            return false;
        }
        if (!SoundAttractMod.CONFIG.enablePickUpAndThrowToSound) {
            return false;
        }
        if (--this.cooldown > 0) {
            class_1308 passenger;
            class_1297 class_12972;
            if (this.mob.method_5782() && (class_12972 = this.mob.method_31483()) instanceof class_1308 && (passenger = (class_1308)class_12972).method_5805()) {
                this.pickUp = passenger;
                return true;
            }
            return false;
        }
        double chance = SoundAttractMod.CONFIG.pickUpChance;
        if (this.mob.method_6051().method_43058() >= chance) {
            return false;
        }
        class_1937 world = this.mob.method_37908();
        if (world.method_8608()) {
            return false;
        }
        this.targetSound = SoundTracker.findNearestSound(world, this.mob, this.mob.method_24515(), this.mob.method_33571());
        if (this.targetSound == null) {
            return false;
        }
        String canPickUpTagStr = SoundAttractMod.CONFIG.pickUpCanPickUpTag;
        if (canPickUpTagStr == null || canPickUpTagStr.isBlank()) {
            return false;
        }
        class_6862 canPickUpTag = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)new class_2960(canPickUpTagStr));
        if (!this.mob.method_5864().method_20210(canPickUpTag)) {
            return false;
        }
        int minDist = SoundAttractMod.CONFIG.pickUpMinDistanceToPickUp;
        double distToSound = Math.sqrt(this.mob.method_24515().method_10262((class_2382)this.targetSound.pos));
        if (distToSound < (double)minDist) {
            return false;
        }
        String canBePickedUpTagStr = SoundAttractMod.CONFIG.pickUpCanBePickedUpTag;
        if (canBePickedUpTagStr == null || canBePickedUpTagStr.isBlank()) {
            return false;
        }
        class_6862 canBePickedUpTag = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)new class_2960(canBePickedUpTagStr));
        double followRange = this.mob.method_26825(class_5134.field_23717);
        double range = followRange > 0.0 ? followRange : 16.0;
        List candidates = world.method_8390(class_1308.class, this.mob.method_5829().method_1014(range), other -> other != this.mob && other.method_5805() && other.method_5864().method_20210(canBePickedUpTag));
        double closestDistSq = Double.MAX_VALUE;
        class_1308 closest = null;
        for (class_1308 candidate : candidates) {
            double d = this.mob.method_5858((class_1297)candidate);
            if (!(d < closestDistSq)) continue;
            closestDistSq = d;
            closest = candidate;
        }
        this.pickUp = closest;
        return this.pickUp != null && this.pickUp.method_5805();
    }

    public boolean method_6266() {
        return this.pickUp != null && this.pickUp.method_5805() && this.targetSound != null && this.targetSound.ticksRemaining > 0;
    }

    public void method_6269() {
        this.mob.method_5988().method_35111((class_1297)this.pickUp);
        this.mob.method_5942().method_6340();
        this.mob.method_5942().method_6335((class_1297)this.pickUp, SoundAttractMod.CONFIG.pickUpSpeedModifier);
        this.pickUp.method_5942().method_6340();
    }

    public void method_6270() {
        this.pickUp = null;
        this.unreachableTime = 0;
        this.targetSound = null;
    }

    private double getFollowDistance() {
        return this.mob.method_26825(class_5134.field_23717);
    }

    public void method_6268() {
        class_1937 world = this.mob.method_37908();
        if (world.method_8608()) {
            return;
        }
        if (this.targetSound == null || this.targetSound.ticksRemaining <= 0) {
            this.targetSound = SoundTracker.findNearestSound(world, this.mob, this.mob.method_24515(), this.mob.method_33571());
            if (this.targetSound == null) {
                this.method_6270();
                return;
            }
        }
        if (this.pickUp == null || !this.pickUp.method_5805()) {
            this.method_6270();
            return;
        }
        if (!this.mob.method_5782()) {
            this.pickUp.method_5942().method_6340();
            if (this.mob.method_5942().method_6357()) {
                this.mob.method_5942().method_6335((class_1297)this.pickUp, SoundAttractMod.CONFIG.pickUpSpeedModifier);
            }
            if (this.mob.method_5858((class_1297)this.pickUp) <= 4.0) {
                this.pickUp.method_5873((class_1297)this.mob, false);
                this.cooldown = 20;
            }
        } else {
            class_2338 soundPos = this.targetSound.pos;
            int maxThrow = SoundAttractMod.CONFIG.pickUpMaxDistanceToThrow;
            double distToSoundSq = this.mob.method_24515().method_10262((class_2382)soundPos);
            if (--this.cooldown <= 0 && distToSoundSq <= (double)(maxThrow * maxThrow)) {
                double dx = (double)soundPos.method_10263() + 0.5 - this.pickUp.method_23317();
                double dy = (double)soundPos.method_10264() + 0.5 - this.pickUp.method_23318();
                double dz = (double)soundPos.method_10260() + 0.5 - this.pickUp.method_23321();
                double distXZ = Math.sqrt(dx * dx + dz * dz);
                class_243 motion = new class_243(dx * 0.1, class_3532.method_15350((double)dy, (double)4.0, (double)40.0) / 10.0 + distXZ / 100.0, dz * 0.1);
                this.pickUp.method_5848();
                this.pickUp.method_18799(motion);
                this.mob.method_5783(class_3417.field_14675, 3.0f, 1.5f);
                this.cooldown = SoundAttractMod.CONFIG.pickUpCooldownTicks;
                this.method_6270();
                return;
            }
        }
        if (++this.unreachableTime > 120) {
            this.cooldown = SoundAttractMod.CONFIG.pickUpCooldownTicks;
            this.method_6270();
        }
    }
}

