/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundAttractMod;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1308;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_5321;

public class RaidManager {
    private static final Map<class_5321<class_1937>, PerWorldData> DATA = new ConcurrentHashMap<class_5321<class_1937>, PerWorldData>();

    private static PerWorldData getData(class_3218 world) {
        return DATA.computeIfAbsent((class_5321<class_1937>)world.method_27983(), k -> new PerWorldData());
    }

    public static void scheduleRaid(class_1308 leader, class_2338 targetPos, long nowTicks) {
        class_1937 class_19372 = leader.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        PerWorldData d = RaidManager.getData(world);
        Raid raid = new Raid(leader, targetPos, nowTicks);
        d.leaderToRaid.put(leader, raid);
        if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[RaidManager] Scheduled RAID for leader {} at {} (countdown {} ticks)", new Object[]{leader.method_5477().getString(), targetPos, raid.ticksRemaining});
        }
    }

    public static boolean isRaidTicking(class_1308 leader) {
        Raid r = RaidManager.getRaid(leader);
        return r != null && !r.advancing && r.ticksRemaining > 0;
    }

    public static boolean isRaidAdvancing(class_1308 leader) {
        Raid r = RaidManager.getRaid(leader);
        return r != null && r.advancing;
    }

    public static class_2338 getRaidTarget(class_1308 leader) {
        Raid r = RaidManager.getRaid(leader);
        return r != null ? r.target : null;
    }

    public static void clearRaid(class_1308 leader) {
        class_1937 class_19372 = leader.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        PerWorldData d = RaidManager.getData(world);
        d.leaderToRaid.remove(leader);
        if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[RaidManager] Cleared RAID for leader {}.", (Object)leader.method_5477().getString());
        }
    }

    private static Raid getRaid(class_1308 leader) {
        class_1937 class_19372 = leader.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return null;
        }
        class_3218 world = (class_3218)class_19372;
        PerWorldData d = RaidManager.getData(world);
        return d.leaderToRaid.get(leader);
    }

    public static void tick(class_3218 world) {
        PerWorldData d = RaidManager.getData(world);
        if (d.leaderToRaid.isEmpty()) {
            return;
        }
        double arrivalDistance = SoundAttractMod.CONFIG != null ? SoundAttractMod.CONFIG.arrivalDistance : 6.0;
        double arrivalDistSq = arrivalDistance * arrivalDistance;
        d.leaderToRaid.entrySet().removeIf(entry -> {
            class_1308 leader = (class_1308)entry.getKey();
            Raid raid = (Raid)entry.getValue();
            if (leader == null || raid == null || !raid.isValid()) {
                return true;
            }
            if (!raid.advancing) {
                --raid.ticksRemaining;
                if (raid.ticksRemaining <= 0) {
                    raid.advancing = true;
                    if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                        SoundAttractMod.LOGGER.info("[RaidManager] RAID READY for leader {}. Advancing to {}", (Object)leader.method_5477().getString(), (Object)raid.target);
                    }
                } else if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging && raid.ticksRemaining % 40 == 0) {
                    SoundAttractMod.LOGGER.info("[RaidManager] RAID ticking... leader {} -> {} ({} ticks left)", new Object[]{leader.method_5477().getString(), raid.target, raid.ticksRemaining});
                }
            } else if (leader.method_5649((double)raid.target.method_10263() + 0.5, (double)raid.target.method_10264() + 0.5, (double)raid.target.method_10260() + 0.5) < arrivalDistSq) {
                if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[RaidManager] RAID completed for leader {} at {}", (Object)leader.method_5477().getString(), (Object)raid.target);
                }
                return true;
            }
            return false;
        });
    }

    private static class PerWorldData {
        final Map<class_1308, Raid> leaderToRaid = Collections.synchronizedMap(new WeakHashMap());
        long lastCleanupTime = -1L;

        private PerWorldData() {
        }
    }

    private static class Raid {
        final WeakReference<class_1308> leaderRef;
        final class_2338 target;
        int ticksRemaining;
        boolean advancing;
        final long scheduledAt;

        Raid(class_1308 leader, class_2338 target, long nowTicks) {
            int configured;
            this.leaderRef = new WeakReference<class_1308>(leader);
            this.target = target;
            this.ticksRemaining = configured = SoundAttractMod.CONFIG != null ? SoundAttractMod.CONFIG.raidCountdownTicks : 200;
            this.advancing = false;
            this.scheduledAt = nowTicks;
        }

        boolean isValid() {
            class_1308 leader = (class_1308)this.leaderRef.get();
            return leader != null && leader.method_5805() && !leader.method_31481();
        }
    }
}

