/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.config;

import com.example.soundattract.config.SoundAttractConfigData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ConfigLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE = "config/soundattract.json";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SoundAttractConfigData load() {
        File file = new File(CONFIG_FILE);
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                JsonElement userJson = JsonParser.parseReader((Reader)reader);
                JsonObject defaultsJson = GSON.toJsonTree((Object)new SoundAttractConfigData()).getAsJsonObject();
                if (userJson != null && userJson.isJsonObject()) {
                    JsonObject userObj = userJson.getAsJsonObject();
                    ConfigLoader.migrateUserJson(userObj);
                    JsonObject merged = ConfigLoader.deepMergeObjects(userObj, defaultsJson);
                    SoundAttractConfigData mergedConfig = (SoundAttractConfigData)GSON.fromJson((JsonElement)merged, SoundAttractConfigData.class);
                    ConfigLoader.save(mergedConfig);
                    SoundAttractConfigData soundAttractConfigData = mergedConfig;
                    return soundAttractConfigData;
                }
                SoundAttractConfigData cfg = new SoundAttractConfigData();
                ConfigLoader.save(cfg);
                SoundAttractConfigData soundAttractConfigData = cfg;
                return soundAttractConfigData;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        SoundAttractConfigData config = new SoundAttractConfigData();
        ConfigLoader.save(config);
        return config;
    }

    public static void save(SoundAttractConfigData config) {
        try (FileWriter writer = new FileWriter(ConfigLoader.ensureConfigPath());){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String ensureConfigPath() throws IOException {
        File file = new File(CONFIG_FILE);
        File parent = file.getParentFile();
        if (!(parent == null || parent.exists() || parent.mkdirs() || parent.exists())) {
            throw new IOException("Failed to create config directory: " + parent.getAbsolutePath());
        }
        return file.getPath();
    }

    private static void migrateUserJson(JsonObject obj) {
        int version;
        int n = version = obj.has("configSchemaVersion") && obj.get("configSchemaVersion").isJsonPrimitive() ? ConfigLoader.safeGetInt(obj.get("configSchemaVersion"), 0) : 0;
        if (version < 1) {
            ConfigLoader.renameKey(obj, "attractedEntityIds", "attractedEntities");
            ConfigLoader.renameKey(obj, "scanCooldown", "scanCooldownTicks");
            ConfigLoader.renameKey(obj, "nonPlayerSounds", "nonPlayerSoundIdList");
            ConfigLoader.renameKey(obj, "nonPlayerSoundWhitelist", "soundIdWhitelist");
            ConfigLoader.renameKey(obj, "edgeMobSmart", "edgeMobSmartBehavior");
            ConfigLoader.renameKey(obj, "pointblankGunShootRanges", "pointblankGunShootRanges");
            ConfigLoader.renameKey(obj, "pointblankAttachmentReductions", "pointblankAttachmentSoundReductions");
            ConfigLoader.renameKey(obj, "pointblankMuzzleFlashReductionsMap", "pointblankMuzzleFlashReductions");
            obj.addProperty("configSchemaVersion", (Number)1);
        }
        if (version < 4) {
            if (!obj.has("enableFleeFromUnseenAttackerGoal")) {
                obj.addProperty("enableFleeFromUnseenAttackerGoal", Boolean.valueOf(true));
            }
            obj.addProperty("configSchemaVersion", (Number)4);
        }
        if (version < 5) {
            if (!obj.has("enableTeleportToSound")) {
                obj.addProperty("enableTeleportToSound", Boolean.valueOf(true));
            }
            if (!obj.has("teleportChance")) {
                obj.addProperty("teleportChance", (Number)0.35);
            }
            if (!obj.has("teleportCooldownTicks")) {
                obj.addProperty("teleportCooldownTicks", (Number)300);
            }
            if (!obj.has("teleportCanTeleportTag")) {
                obj.addProperty("teleportCanTeleportTag", "enhancedai:mobs/teleport_to_target/can_teleport");
            }
            if (!obj.has("teleportCanBeTeleportedTag")) {
                obj.addProperty("teleportCanBeTeleportedTag", "enhancedai:mobs/teleport_to_target/can_be_teleported");
            }
            if (!obj.has("enablePickUpAndThrowToSound")) {
                obj.addProperty("enablePickUpAndThrowToSound", Boolean.valueOf(true));
            }
            if (!obj.has("pickUpChance")) {
                obj.addProperty("pickUpChance", (Number)0.05);
            }
            if (!obj.has("pickUpCooldownTicks")) {
                obj.addProperty("pickUpCooldownTicks", (Number)600);
            }
            if (!obj.has("pickUpMinDistanceToPickUp")) {
                obj.addProperty("pickUpMinDistanceToPickUp", (Number)5);
            }
            if (!obj.has("pickUpMaxDistanceToThrow")) {
                obj.addProperty("pickUpMaxDistanceToThrow", (Number)24);
            }
            if (!obj.has("pickUpSpeedModifier")) {
                obj.addProperty("pickUpSpeedModifier", (Number)1.25);
            }
            if (!obj.has("pickUpCanPickUpTag")) {
                obj.addProperty("pickUpCanPickUpTag", "enhancedai:mobs/pick_up_and_throw/can_pick_up");
            }
            if (!obj.has("pickUpCanBePickedUpTag")) {
                obj.addProperty("pickUpCanBePickedUpTag", "enhancedai:mobs/pick_up_and_throw/can_be_picked_up");
            }
            if (!obj.has("enableXrayTargeting")) {
                obj.addProperty("enableXrayTargeting", Boolean.valueOf(true));
            }
            if (!obj.has("xrayApplyTag")) {
                obj.addProperty("xrayApplyTag", "enhancedai:mobs/targeting/apply_xray");
            }
            if (!obj.has("xrayRequireBetterNearby")) {
                obj.addProperty("xrayRequireBetterNearby", Boolean.valueOf(true));
            }
            if (!obj.has("xrayBetterNearbyTag")) {
                obj.addProperty("xrayBetterNearbyTag", "enhancedai:mobs/targeting/better_nearby_targeting");
            }
            if (!obj.has("xrayMinRange")) {
                obj.addProperty("xrayMinRange", (Number)16);
            }
            if (!obj.has("xrayMaxRange")) {
                obj.addProperty("xrayMaxRange", (Number)24);
            }
            if (!obj.has("xrayChance")) {
                obj.addProperty("xrayChance", (Number)0.5);
            }
            obj.addProperty("configSchemaVersion", (Number)5);
        }
    }

    private static void renameKey(JsonObject obj, String oldKey, String newKey) {
        if (!oldKey.equals(newKey) && obj.has(oldKey) && !obj.has(newKey)) {
            obj.add(newKey, obj.get(oldKey));
            obj.remove(oldKey);
        }
    }

    private static int safeGetInt(JsonElement el, int fallback) {
        try {
            if (el != null && el.isJsonPrimitive()) {
                return el.getAsInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fallback;
    }

    private static JsonObject deepMergeObjects(JsonObject user, JsonObject defaults) {
        for (String key : user.keySet()) {
            JsonElement userVal = user.get(key);
            if (!defaults.has(key)) {
                defaults.add(key, userVal);
                continue;
            }
            JsonElement defVal = defaults.get(key);
            if (userVal != null && userVal.isJsonObject() && defVal != null && defVal.isJsonObject()) {
                ConfigLoader.deepMergeObjects(userVal.getAsJsonObject(), defVal.getAsJsonObject());
                continue;
            }
            defaults.add(key, userVal);
        }
        return defaults;
    }
}

