/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ArmorColorsReloadListener
extends SimpleJsonResourceReloadListener {
    public ArmorColorsReloadListener() {
        super(new Gson(), "camo/armor_colors");
    }

    protected void apply(Map<ResourceLocation, JsonElement> elements, ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap<ResourceLocation, Integer> colors = new HashMap<ResourceLocation, Integer>();
        boolean replace = false;
        for (Map.Entry<ResourceLocation, JsonElement> entry : elements.entrySet()) {
            JsonElement element = entry.getValue();
            if (!element.isJsonObject()) continue;
            JsonObject obj = element.getAsJsonObject();
            if (obj.has("replace") && obj.get("replace").isJsonPrimitive() && obj.get("replace").getAsJsonPrimitive().isBoolean() && obj.get("replace").getAsBoolean()) {
                replace = true;
                colors.clear();
            }
            if (!obj.has("colors") || !obj.get("colors").isJsonObject()) continue;
            JsonObject colorsObj = obj.getAsJsonObject("colors");
            for (Map.Entry colorEntry : colorsObj.entrySet()) {
                Integer colorInt;
                String colorStr;
                String key = ((String)colorEntry.getKey()).trim();
                JsonElement val = (JsonElement)colorEntry.getValue();
                if (!val.isJsonPrimitive() || (colorStr = val.getAsString().trim()).isEmpty() || (colorInt = ArmorColorsReloadListener.parseColor(colorStr)) == null) continue;
                if (key.startsWith("#")) {
                    String tagIdStr = key.substring(1);
                    ResourceLocation tagId = ResourceLocation.m_135820_((String)tagIdStr);
                    if (tagId == null) continue;
                    this.expandItemTagWithColor(tagId, colorInt, colors);
                    continue;
                }
                ResourceLocation itemId = ResourceLocation.m_135820_((String)key);
                if (itemId == null) continue;
                colors.put(itemId, colorInt);
            }
        }
        SoundAttractConfig.DP_CUSTOM_ARMOR_COLORS.clear();
        SoundAttractConfig.DP_CUSTOM_ARMOR_COLORS.putAll(colors);
        try {
            SoundAttractConfig.bakeConfig();
        }
        catch (Throwable t) {
            SoundAttractMod.LOGGER.warn("[ArmorColorsReloadListener] Failed to re-bake config after datapack reload", t);
        }
    }

    private static Integer parseColor(String colorStr) {
        String s = colorStr.trim();
        if (s.startsWith("#")) {
            s = s.substring(1);
        }
        if (s.length() != 6) {
            return null;
        }
        try {
            int rgb = Integer.parseInt(s, 16);
            return rgb & 0xFFFFFF;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void expandItemTagWithColor(ResourceLocation tagId, int color, Map<ResourceLocation, Integer> target) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        HolderLookup.RegistryLookup lookup = server.m_206579_().m_255025_(Registries.f_256913_);
        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagId);
        for (Holder holder : lookup.m_254956_(tagKey)) {
            holder.m_203543_().ifPresent(k -> target.put(k.m_135782_(), color));
        }
    }
}

