/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundAttractionEvents;
import com.example.soundattract.config.SoundAttractConfig;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.server.ServerLifecycleHooks;

public class SoundDefinitionsReloadListener
extends SimpleJsonResourceReloadListener {
    public SoundDefinitionsReloadListener() {
        super(new Gson(), "sounds");
    }

    protected void apply(Map<ResourceLocation, JsonElement> elements, ResourceManager resourceManager, ProfilerFiller profiler) {
        HashSet<ResourceLocation> whitelist = new HashSet<ResourceLocation>();
        HashMap<ResourceLocation, SoundAttractConfig.SoundDefaultEntry> defaults = new HashMap<ResourceLocation, SoundAttractConfig.SoundDefaultEntry>();
        boolean replaceWhitelist = false;
        boolean replaceDefaults = false;
        for (Map.Entry<ResourceLocation, JsonElement> entry : elements.entrySet()) {
            JsonElement element = entry.getValue();
            if (!element.isJsonObject()) continue;
            JsonObject obj = element.getAsJsonObject();
            if (obj.has("replace_whitelist") && obj.get("replace_whitelist").isJsonPrimitive() && obj.get("replace_whitelist").getAsJsonPrimitive().isBoolean() && obj.get("replace_whitelist").getAsBoolean()) {
                replaceWhitelist = true;
                whitelist.clear();
            }
            if (obj.has("replace_defaults") && obj.get("replace_defaults").isJsonPrimitive() && obj.get("replace_defaults").getAsJsonPrimitive().isBoolean() && obj.get("replace_defaults").getAsBoolean()) {
                replaceDefaults = true;
                defaults.clear();
            }
            if (obj.has("whitelist") && obj.get("whitelist").isJsonArray()) {
                for (JsonElement e : obj.get("whitelist").getAsJsonArray()) {
                    String idOrTag;
                    if (!e.isJsonPrimitive() || !e.getAsJsonPrimitive().isString() || (idOrTag = e.getAsString().trim()).isEmpty()) continue;
                    if (idOrTag.startsWith("#")) {
                        String tagIdStr = idOrTag.substring(1);
                        ResourceLocation tagId = ResourceLocation.m_135820_((String)tagIdStr);
                        if (tagId == null) continue;
                        this.expandSoundTag(tagId, whitelist);
                        continue;
                    }
                    ResourceLocation soundId = ResourceLocation.m_135820_((String)idOrTag);
                    if (soundId == null) continue;
                    whitelist.add(soundId);
                }
            }
            if (!obj.has("defaults") || !obj.get("defaults").isJsonObject()) continue;
            JsonObject defaultsObj = obj.getAsJsonObject("defaults");
            for (Map.Entry defEntry : defaultsObj.entrySet()) {
                JsonObject defObj;
                String key = ((String)defEntry.getKey()).trim();
                JsonElement valueEl = (JsonElement)defEntry.getValue();
                if (!valueEl.isJsonObject() || !(defObj = valueEl.getAsJsonObject()).has("range") || !defObj.has("weight")) continue;
                try {
                    double range = defObj.get("range").getAsDouble();
                    double weight = defObj.get("weight").getAsDouble();
                    if (key.startsWith("#")) {
                        String tagIdStr = key.substring(1);
                        ResourceLocation tagId = ResourceLocation.m_135820_((String)tagIdStr);
                        if (tagId == null) continue;
                        this.expandSoundTagWithDefault(tagId, range, weight, defaults);
                        continue;
                    }
                    ResourceLocation soundId = ResourceLocation.m_135820_((String)key);
                    if (soundId == null) continue;
                    defaults.put(soundId, new SoundAttractConfig.SoundDefaultEntry(range, weight));
                }
                catch (Exception exception) {}
            }
        }
        SoundAttractConfig.DP_SOUND_WHITELIST_CACHE.clear();
        SoundAttractConfig.DP_SOUND_WHITELIST_CACHE.addAll(whitelist);
        SoundAttractConfig.DP_SOUND_DEFAULTS_CACHE.clear();
        SoundAttractConfig.DP_SOUND_DEFAULTS_CACHE.putAll(defaults);
        try {
            SoundAttractConfig.bakeConfig();
            SoundAttractionEvents.invalidateCachedEntityTypes();
        }
        catch (Throwable t) {
            SoundAttractMod.LOGGER.warn("[SoundDefinitionsReloadListener] Failed to re-bake config after datapack reload", t);
        }
    }

    private void expandSoundTag(ResourceLocation tagId, Set<ResourceLocation> whitelist) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        HolderLookup.RegistryLookup lookup = server.m_206579_().m_255025_(Registries.f_256840_);
        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256840_, (ResourceLocation)tagId);
        for (Holder holder : lookup.m_254956_(tagKey)) {
            holder.m_203543_().ifPresent(k -> whitelist.add(k.m_135782_()));
        }
    }

    private void expandSoundTagWithDefault(ResourceLocation tagId, double range, double weight, Map<ResourceLocation, SoundAttractConfig.SoundDefaultEntry> defaults) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        HolderLookup.RegistryLookup lookup = server.m_206579_().m_255025_(Registries.f_256840_);
        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256840_, (ResourceLocation)tagId);
        for (Holder holder : lookup.m_254956_(tagKey)) {
            holder.m_203543_().ifPresent(k -> defaults.put(k.m_135782_(), new SoundAttractConfig.SoundDefaultEntry(range, weight)));
        }
    }
}

