/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.CamoUtil;
import com.example.soundattract.DynamicScanCooldownManager;
import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundAttractionEvents;
import com.example.soundattract.SoundTracker;
import com.example.soundattract.StealthDetectionEvents;
import com.example.soundattract.ai.BlockBreakerManager;
import com.example.soundattract.ai.BlockBreakerPosGoal;
import com.example.soundattract.config.MobProfile;
import com.example.soundattract.config.PlayerStance;
import com.example.soundattract.config.SoundAttractConfig;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AttractionGoal
extends Goal {
    private final Mob mob;
    private final double moveSpeed;
    private BlockPos targetSoundPos;
    private double currentTargetWeight = -1.0;
    private BlockPos lastPos = null;
    private int stuckTicks = 0;
    private int scanCooldownCounter = 0;
    private SoundTracker.SoundRecord cachedSound = null;
    private boolean isPursuingSound = false;
    private int pursuingSoundTicksRemaining = 0;
    private BlockBreakerPosGoal blockBreakerGoal = null;
    private SoundTracker.SoundRecord soundResultCache = null;
    private long cacheTick = -1L;
    private long lastMoveToTick = -1L;
    private BlockPos lastMoveToTarget = null;
    private static final int MOVE_TO_COOLDOWN_TICKS = 20;

    public AttractionGoal(Mob mob, double moveSpeed) {
        this.mob = mob;
        this.moveSpeed = (Double)SoundAttractConfig.COMMON.mobMoveSpeed.get();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    private int scanCooldownTicks() {
        return DynamicScanCooldownManager.currentScanCooldownTicks;
    }

    private boolean isMobEligible() {
        Set<EntityType<?>> attractedTypes = SoundAttractionEvents.getCachedAttractedEntityTypes();
        boolean byType = attractedTypes.contains(this.mob.m_6095_());
        boolean hasProfile = SoundAttractConfig.getMatchingProfile(this.mob) != null;
        return byType || hasProfile;
    }

    private double getArrivalDistance() {
        return (Double)SoundAttractConfig.COMMON.arrivalDistance.get();
    }

    private int getWaitTicks() {
        return (Integer)SoundAttractConfig.COMMON.scanCooldownTicks.get();
    }

    private PlayerStance determinePlayerStance(LivingEntity player) {
        if ((player.m_20089_() == Pose.SWIMMING || player.m_20089_() == Pose.FALL_FLYING || player.m_20089_() == Pose.SPIN_ATTACK) && player.m_20206_() < 1.0f) {
            return PlayerStance.CRAWLING;
        }
        if (player.m_6047_()) {
            return PlayerStance.SNEAKING;
        }
        return PlayerStance.STANDING;
    }

    private double getDetectionRangeForPlayer(LivingEntity player) {
        double baseRange;
        MobProfile mobProfile = SoundAttractConfig.getMatchingProfile(this.mob);
        PlayerStance currentStance = this.determinePlayerStance(player);
        Optional<Object> override = Optional.empty();
        if (mobProfile != null) {
            override = mobProfile.getDetectionOverride(currentStance);
        }
        if (override.isPresent()) {
            baseRange = (Double)override.get();
        } else {
            switch (currentStance) {
                case CRAWLING: {
                    baseRange = (Double)SoundAttractConfig.COMMON.crawlingDetectionRangePlayer.get();
                    break;
                }
                case SNEAKING: {
                    baseRange = (Double)SoundAttractConfig.COMMON.sneakingDetectionRangePlayer.get();
                    break;
                }
                default: {
                    baseRange = (Double)SoundAttractConfig.COMMON.standingDetectionRangePlayer.get();
                }
            }
        }
        boolean hasCamouflage = false;
        int wornCamouflagePieces = 0;
        if (((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get()).booleanValue()) {
            for (ItemStack armorItem : player.m_6168_()) {
                if (armorItem.m_41619_() || !CamoUtil.isCamouflageArmorItem(armorItem.m_41720_())) continue;
                ++wornCamouflagePieces;
            }
            if (((Boolean)SoundAttractConfig.COMMON.requireFullSetForCamouflageBonus.get()).booleanValue()) {
                hasCamouflage = wornCamouflagePieces == 4;
            } else {
                boolean bl = hasCamouflage = wornCamouflagePieces > 0;
            }
        }
        if (hasCamouflage) {
            double totalEffectiveness = 0.0;
            ArrayList armorItems = new ArrayList();
            player.m_6168_().forEach(armorItems::add);
            block11: for (int i = 0; i < armorItems.size(); ++i) {
                Item item;
                ItemStack stack = (ItemStack)armorItems.get(i);
                if (stack.m_41619_() || !CamoUtil.isCamouflageArmorItem(item = stack.m_41720_())) continue;
                switch (i) {
                    case 3: {
                        totalEffectiveness += ((Double)SoundAttractConfig.COMMON.helmetCamouflageEffectiveness.get()).doubleValue();
                        continue block11;
                    }
                    case 2: {
                        totalEffectiveness += ((Double)SoundAttractConfig.COMMON.chestplateCamouflageEffectiveness.get()).doubleValue();
                        continue block11;
                    }
                    case 1: {
                        totalEffectiveness += ((Double)SoundAttractConfig.COMMON.leggingsCamouflageEffectiveness.get()).doubleValue();
                        continue block11;
                    }
                    case 0: {
                        totalEffectiveness += ((Double)SoundAttractConfig.COMMON.bootsCamouflageEffectiveness.get()).doubleValue();
                    }
                }
            }
            baseRange *= Math.max(0.0, 1.0 - totalEffectiveness);
        }
        return Math.max(0.0, baseRange);
    }

    private boolean shouldSuppressTargeting() {
        return (Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get() != false && StealthDetectionEvents.shouldSuppressTargeting(this.mob);
    }

    public boolean m_8036_() {
        if (this.mob.m_20160_() || this.mob.m_5803_() || this.shouldSuppressTargeting()) {
            return false;
        }
        if (!this.isMobEligible()) {
            return false;
        }
        if (this.scanCooldownCounter > 0) {
            --this.scanCooldownCounter;
            return false;
        }
        this.scanCooldownCounter = this.scanCooldownTicks();
        SoundTracker.SoundRecord newSound = this.findInterestingSoundRecord();
        if (newSound == null) {
            return false;
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[AttractionGoal] Mob {} found sound: pos={}, range={}, weight={}", new Object[]{this.mob.m_7755_().getString(), newSound.pos, newSound.range, newSound.weight});
        }
        this.targetSoundPos = newSound.pos;
        this.currentTargetWeight = newSound.weight;
        this.cachedSound = newSound;
        return true;
    }

    public boolean m_8045_() {
        SoundTracker.SoundRecord bestSoundNow;
        if (!this.isMobEligible() || this.mob.m_20160_() || this.mob.m_5803_() || this.shouldSuppressTargeting()) {
            return false;
        }
        if (this.targetSoundPos == null) {
            return false;
        }
        if (this.mob.m_21573_().m_26571_()) {
            BlockPos destination = null;
            destination = this.targetSoundPos;
            if (destination != null && this.mob.m_20183_().m_123331_((Vec3i)destination) < 4.0) {
                return false;
            }
        }
        if ((bestSoundNow = this.getCachedNearestSound()) == null) {
            return false;
        }
        if (bestSoundNow.pos.equals((Object)this.targetSoundPos)) {
            this.cachedSound = bestSoundNow;
            this.currentTargetWeight = bestSoundNow.weight;
            return true;
        }
        double switchRatio = (Double)SoundAttractConfig.COMMON.soundSwitchRatio.get();
        if (bestSoundNow.weight > this.currentTargetWeight * switchRatio) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[AttractionGoal] Mob {} is switching from target {} (weight {}) to {} (weight {})", new Object[]{this.mob.m_7755_().getString(), this.targetSoundPos, this.currentTargetWeight, bestSoundNow.pos, bestSoundNow.weight});
            }
            return false;
        }
        return true;
    }

    private SoundTracker.SoundRecord getCachedNearestSound() {
        long currentTick = this.mob.m_9236_().m_46467_();
        if (this.cacheTick == currentTick) {
            return this.soundResultCache;
        }
        this.cacheTick = currentTick;
        this.soundResultCache = SoundTracker.findNearestSound(this.mob, this.mob.m_9236_(), this.mob.m_20183_(), this.mob.m_146892_(), this.cachedSound != null ? this.cachedSound.soundId : null);
        return this.soundResultCache;
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
        this.targetSoundPos = null;
        this.currentTargetWeight = -1.0;
        this.cachedSound = null;
        this.isPursuingSound = false;
        this.pursuingSoundTicksRemaining = 0;
        this.lastMoveToTick = -1L;
        this.lastMoveToTarget = null;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("AttractionGoal stop: " + this.mob.m_7755_().getString());
        }
    }

    public void m_8037_() {
        boolean shouldRecalc;
        SoundTracker.SoundRecord currentPursuedSound;
        if (this.blockBreakerGoal != null && this.mob.f_21345_.m_25386_().anyMatch(g -> g.m_26015_() == this.blockBreakerGoal)) {
            double switchRatio;
            SoundTracker.SoundRecord bestPossibleSound = this.getCachedNearestSound();
            if (bestPossibleSound != null && this.cachedSound != null && !this.areSoundsEffectivelySame(bestPossibleSound, this.cachedSound) && bestPossibleSound.weight > this.cachedSound.weight * (switchRatio = ((Double)SoundAttractConfig.COMMON.soundSwitchRatio.get()).doubleValue())) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[AttractionGoal] Mining mob {} found a better sound ({} > {}). Stopping block breaking.", new Object[]{this.mob.m_7755_().getString(), bestPossibleSound.weight, this.cachedSound.weight});
                }
                BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                this.blockBreakerGoal = null;
                this.m_8041_();
                return;
            }
            if (this.lastPos != null && this.mob.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)this.lastPos)) >= 1.0) {
                BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                this.blockBreakerGoal = null;
                this.stuckTicks = 0;
                this.lastPos = this.mob.m_20183_();
            }
            return;
        }
        SoundTracker.SoundRecord fresh = this.findInterestingSoundRecord();
        double switchRatio = (Double)SoundAttractConfig.COMMON.soundSwitchRatio.get();
        if (fresh != null) {
            if (this.targetSoundPos != null && fresh.pos.equals((Object)this.targetSoundPos)) {
                this.cachedSound = fresh;
                this.currentTargetWeight = fresh.weight;
            } else {
                boolean isBetterByWeight = fresh.weight > this.currentTargetWeight * switchRatio;
                boolean isTieButCloser = false;
                if (!isBetterByWeight && this.targetSoundPos != null && Math.abs(fresh.weight - this.currentTargetWeight) < 0.001) {
                    double currentDistSq;
                    double freshDistSq = fresh.pos.m_123331_((Vec3i)this.mob.m_20183_());
                    boolean bl = isTieButCloser = freshDistSq < (currentDistSq = this.targetSoundPos.m_123331_((Vec3i)this.mob.m_20183_()));
                }
                if (isBetterByWeight || isTieButCloser) {
                    this.targetSoundPos = fresh.pos;
                    this.cachedSound = fresh;
                    this.currentTargetWeight = fresh.weight;
                    this.mob.m_21573_().m_26573_();
                }
            }
        }
        if (this.targetSoundPos == null) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("AttractionGoal tick: targetSoundPos is null for " + this.mob.m_7755_().getString() + ", goal will likely stop.");
            }
            return;
        }
        if (this.scanCooldownCounter > 0) {
            --this.scanCooldownCounter;
        }
        if (this.lastPos != null && this.mob.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)this.lastPos)) < 1.0) {
            ++this.stuckTicks;
        } else {
            this.stuckTicks = 0;
            if (this.blockBreakerGoal != null) {
                BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                this.blockBreakerGoal = null;
            }
        }
        if (this.stuckTicks == 0) {
            this.lastPos = this.mob.m_20183_();
        }
        if (this.stuckTicks >= 40 && ((Boolean)SoundAttractConfig.COMMON.enableBlockBreaking.get()).booleanValue()) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue() && this.stuckTicks == 40) {
                SoundAttractMod.LOGGER.info("[AttractionGoal DEBUG] Mob {} truly stuck. stuckTicks: {}, navigation.isStuck(): {}", new Object[]{this.mob.m_7755_().getString(), this.stuckTicks, this.mob.m_21573_().m_26577_()});
            }
            if (this.blockBreakerGoal == null) {
                BlockPos destination = this.targetSoundPos;
                if (this.mob.m_21573_().m_26571_()) {
                    if (destination != null && this.mob.m_20183_().m_123331_((Vec3i)destination) > 4.0) {
                        ++this.stuckTicks;
                        if (this.stuckTicks >= 20 && ((Boolean)SoundAttractConfig.COMMON.enableBlockBreaking.get()).booleanValue() && this.blockBreakerGoal == null) {
                            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                                SoundAttractMod.LOGGER.info("[AttractionGoal] Mob {} navigation is DONE and it's far from its goal. Deploying BlockBreakerPosGoal.", (Object)this.mob.m_7755_().getString());
                            }
                            double timeMultiplier = (Double)SoundAttractConfig.COMMON.blockBreakingTimeMultiplier.get();
                            boolean toolOnly = (Boolean)SoundAttractConfig.COMMON.blockBreakingToolOnly.get();
                            boolean properTool = (Boolean)SoundAttractConfig.COMMON.blockBreakingProperToolOnly.get();
                            BlockBreakerPosGoal newGoal = new BlockBreakerPosGoal(this.mob, destination, timeMultiplier, toolOnly, properTool, properTool);
                            BlockBreakerManager.scheduleAdd(this.mob, newGoal, 1);
                            this.blockBreakerGoal = newGoal;
                        }
                    } else {
                        this.stuckTicks = 0;
                    }
                } else {
                    this.stuckTicks = 0;
                    if (this.blockBreakerGoal != null) {
                        BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                        this.blockBreakerGoal = null;
                    }
                }
            }
        }
        if ((currentPursuedSound = this.cachedSound) == null || !currentPursuedSound.pos.equals((Object)this.targetSoundPos)) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("AttractionGoal tick: Cached sound mismatch for {} during expiration check. Target: {}, Cached: {}", new Object[]{this.mob.m_7755_().getString(), this.targetSoundPos, currentPursuedSound != null ? currentPursuedSound.pos : "null"});
            }
            currentPursuedSound = null;
        }
        if (currentPursuedSound == null || currentPursuedSound.ticksRemaining <= 0) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("AttractionGoal tick: Sound at " + this.targetSoundPos + " (from cache) expired or removed for " + this.mob.m_7755_().getString());
            }
            this.targetSoundPos = null;
            return;
        }
        boolean targetChanged = this.lastMoveToTarget == null || !this.lastMoveToTarget.equals((Object)this.targetSoundPos);
        long nowTick = this.mob.m_9236_().m_46467_();
        boolean cooldownElapsed = this.lastMoveToTick < 0L || nowTick - this.lastMoveToTick >= 20L;
        boolean navDone = this.mob.m_21573_().m_26571_();
        boolean bl = shouldRecalc = targetChanged || navDone || cooldownElapsed || this.mob.m_21573_().m_26577_();
        if (shouldRecalc && this.targetSoundPos != null) {
            this.mob.m_21573_().m_26519_((double)this.targetSoundPos.m_123341_(), (double)this.targetSoundPos.m_123342_(), (double)this.targetSoundPos.m_123343_(), this.moveSpeed);
            this.lastMoveToTick = nowTick;
            this.lastMoveToTarget = this.targetSoundPos;
        }
        if (this.isPursuingSound && this.cachedSound != null) {
            if (this.pursuingSoundTicksRemaining > 0) {
                --this.pursuingSoundTicksRemaining;
                if (this.pursuingSoundTicksRemaining <= 0) {
                    this.isPursuingSound = false;
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("AttractionGoal tick: " + this.mob.m_7755_().getString() + " pursuit timer expired. Will re-evaluate sounds.");
                    }
                }
            }
        } else if (!this.isPursuingSound) {
            this.pursuingSoundTicksRemaining = 0;
        }
        if (this.mob.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)this.targetSoundPos)) < this.getArrivalDistance() * this.getArrivalDistance() && ((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("AttractionGoal tick: " + this.mob.m_7755_().getString() + " arrived at " + this.targetSoundPos + ". Scan cooldown will apply if it re-evaluates canUse.");
        }
    }

    protected SoundTracker.SoundRecord findInterestingSoundRecord() {
        Level level = this.mob.m_9236_();
        if (level.m_5776_()) {
            return null;
        }
        BlockPos mobPos = this.mob.m_20183_();
        SoundTracker.SoundRecord bestSoundOverall = this.getCachedNearestSound();
        SoundTracker.SoundRecord currentTargetSound = this.cachedSound;
        if (currentTargetSound != null && bestSoundOverall != null && !this.areSoundsEffectivelySame(currentTargetSound, bestSoundOverall)) {
            boolean canSwitch;
            double switchRatio = (Double)SoundAttractConfig.COMMON.soundSwitchRatio.get();
            boolean bl = canSwitch = bestSoundOverall.weight > currentTargetSound.weight * switchRatio || Math.abs(bestSoundOverall.weight - currentTargetSound.weight) < 0.001 && bestSoundOverall.pos.m_123331_((Vec3i)mobPos) < currentTargetSound.pos.m_123331_((Vec3i)mobPos);
            if (!canSwitch) {
                return currentTargetSound;
            }
        }
        if (bestSoundOverall != null) {
            this.isPursuingSound = true;
            this.pursuingSoundTicksRemaining = DynamicScanCooldownManager.currentScanCooldownTicks;
        } else {
            this.isPursuingSound = false;
            this.pursuingSoundTicksRemaining = 0;
        }
        this.cachedSound = bestSoundOverall;
        return bestSoundOverall;
    }

    private boolean areSoundsEffectivelySame(SoundTracker.SoundRecord s1, SoundTracker.SoundRecord s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.pos.equals((Object)s2.pos) && s1.soundId != null && s1.soundId.equals(s2.soundId) && Math.abs(s1.range - s2.range) < 0.1 && Math.abs(s1.weight - s2.weight) < 0.01;
    }

    private boolean isPlayerMovementSound(double weight) {
        return weight == 1.2 || weight == 0.6 || weight == 0.2 || weight == 0.1;
    }

    public boolean isPursuingSound() {
        return this.isPursuingSound;
    }
}

