/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.config;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.PlayerStance;
import com.example.soundattract.config.SoundOverride;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.registries.ForgeRegistries;

public class MobProfile {
    private final String profileName;
    private final String mobIdString;
    @Nullable
    private final ResourceLocation mobId;
    @Nullable
    private final CompoundTag nbtMatcher;
    private final List<SoundOverride> soundOverrides;
    private final Map<PlayerStance, Double> detectionOverrides;
    private final boolean isValid;

    public MobProfile(String profileName, String mobIdString, @Nullable String nbtMatcherString, List<SoundOverride> soundOverrides, Map<PlayerStance, Double> detectionOverrides) {
        this.profileName = Objects.requireNonNull(profileName, "profileName cannot be null");
        this.mobIdString = Objects.requireNonNull(mobIdString, "mobIdString cannot be null");
        boolean profileIsValid = true;
        if ("*".equals(mobIdString)) {
            this.mobId = null;
        } else {
            this.mobId = ResourceLocation.m_135820_((String)mobIdString);
            if (this.mobId == null) {
                SoundAttractMod.LOGGER.warn("Invalid mobIdString for profile '{}': {}. This profile will be disabled.", (Object)profileName, (Object)mobIdString);
                profileIsValid = false;
            }
        }
        this.isValid = profileIsValid;
        CompoundTag parsedNbt = null;
        if (nbtMatcherString != null && !nbtMatcherString.trim().isEmpty()) {
            try {
                parsedNbt = TagParser.m_129359_((String)nbtMatcherString);
            }
            catch (Exception e) {
                SoundAttractMod.LOGGER.warn("Failed to parse NBT matcher for profile '{}': {}. Error: {}", new Object[]{profileName, nbtMatcherString, e.getMessage()});
            }
        }
        this.nbtMatcher = parsedNbt;
        this.soundOverrides = Collections.unmodifiableList(Objects.requireNonNull(soundOverrides, "soundOverrides cannot be null"));
        this.detectionOverrides = Collections.unmodifiableMap(Objects.requireNonNull(detectionOverrides, "detectionOverrides cannot be null"));
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getMobIdString() {
        return this.mobIdString;
    }

    @Nullable
    public ResourceLocation getMobId() {
        return this.mobId;
    }

    @Nullable
    public CompoundTag getNbtMatcher() {
        return this.nbtMatcher;
    }

    public List<SoundOverride> getSoundOverrides() {
        return this.soundOverrides;
    }

    public Map<PlayerStance, Double> getDetectionOverrides() {
        return this.detectionOverrides;
    }

    public Optional<Double> getDetectionOverride(PlayerStance stance) {
        return Optional.ofNullable(this.detectionOverrides.get((Object)stance));
    }

    public Optional<SoundOverride> getSoundOverride(ResourceLocation soundId) {
        return this.soundOverrides.stream().filter(override -> override.getSoundId().equals((Object)soundId)).findFirst();
    }

    public boolean matches(Mob mob) {
        CompoundTag mobNbt;
        if (!this.isValid) {
            return false;
        }
        if (this.mobId == null) {
            if (this.nbtMatcher != null && !this.nbtMatcher.m_128456_()) {
                CompoundTag mobNbt2 = mob.m_20240_(new CompoundTag());
                return this.checkNbt(mobNbt2, this.nbtMatcher);
            }
            return true;
        }
        ResourceLocation actualMobId = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
        if (!this.mobId.equals((Object)actualMobId)) {
            return false;
        }
        return this.nbtMatcher == null || this.nbtMatcher.m_128456_() || this.checkNbt(mobNbt = mob.m_20240_(new CompoundTag()), this.nbtMatcher);
    }

    private boolean checkNbt(CompoundTag mobNbt, CompoundTag matcherNbt) {
        for (String key : matcherNbt.m_128431_()) {
            if (!mobNbt.m_128425_(key, (int)matcherNbt.m_128435_(key))) {
                return false;
            }
            if (matcherNbt.m_128435_(key) == 10) {
                if (this.checkNbt(mobNbt.m_128469_(key), matcherNbt.m_128469_(key))) continue;
                return false;
            }
            if (matcherNbt.m_128435_(key) == 9) {
                if (mobNbt.m_128437_(key, (int)matcherNbt.m_128437_(key, 0).m_7264_()).equals((Object)matcherNbt.m_128437_(key, 0))) continue;
                SoundAttractMod.LOGGER.trace("NBT list matching for key '{}' is currently basic. Profile: {}", (Object)key, (Object)this.profileName);
                continue;
            }
            if (mobNbt.m_128423_(key).equals(matcherNbt.m_128423_(key))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "MobProfile{profileName='" + this.profileName + "', mobIdString='" + this.mobIdString + "'" + (String)(this.mobId != null ? ", mobId=" + this.mobId : "") + (String)(this.nbtMatcher != null ? ", nbtMatcher=" + this.nbtMatcher.m_7916_() : "") + ", soundOverrides=" + this.soundOverrides + ", detectionOverrides=" + this.detectionOverrides + "}";
    }
}

