/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration;

import com.example.soundattract.config.SoundAttractConfig;
import insane96mcp.enhancedai.modules.mobs.miner.MinerMobs;
import insane96mcp.enhancedai.modules.mobs.pickandthrow.PickUpAndThrow;
import insane96mcp.enhancedai.modules.mobs.teleporttotarget.TeleportToTarget;
import insane96mcp.enhancedai.setup.EAIAttributes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModList;

public class EnhancedAICompat {
    private static final boolean IS_ENHANCED_AI_LOADED = ModList.get().isLoaded("enhancedai");
    private static final int DEFAULT_MAX_Y = 256;
    private static final boolean DEFAULT_BLACKLIST_TILES = true;
    private static final boolean DEFAULT_BLACKLIST_AS_WHITELIST = false;
    private static final TagKey<Block> EMPTY_BLACKLIST = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("soundattract", "empty_block_tag"));

    public static int getMaxY() {
        if (IS_ENHANCED_AI_LOADED) {
            return MinerMobsProxy.getMaxY();
        }
        return 256;
    }

    public static boolean shouldBlacklistTileEntities() {
        if (IS_ENHANCED_AI_LOADED) {
            return MinerMobsProxy.blacklistTileEntities();
        }
        return true;
    }

    public static boolean isBlacklistAsWhitelist() {
        if (IS_ENHANCED_AI_LOADED) {
            return MinerMobsProxy.isBlacklistAsWhitelist();
        }
        return false;
    }

    public static TagKey<Block> getBlockBlacklistTag() {
        if (IS_ENHANCED_AI_LOADED) {
            return MinerMobsProxy.getBlockBlacklistTag();
        }
        return EMPTY_BLACKLIST;
    }

    public static double getTeleportToTargetChance(Level level) {
        if (IS_ENHANCED_AI_LOADED) {
            return TeleportProxy.getChance(level);
        }
        return (Double)SoundAttractConfig.COMMON.teleportChance.get();
    }

    public static int getTeleportCooldownTicks() {
        if (IS_ENHANCED_AI_LOADED) {
            return TeleportProxy.getCooldown();
        }
        return (Integer)SoundAttractConfig.COMMON.teleportCooldownTicks.get();
    }

    public static double getPickUpAndThrowChance(Level level) {
        if (IS_ENHANCED_AI_LOADED) {
            return PickUpProxy.getChance(level);
        }
        return (Double)SoundAttractConfig.COMMON.pickUpChance.get();
    }

    public static int getPickUpMinDistanceToPickUp() {
        if (IS_ENHANCED_AI_LOADED) {
            return PickUpProxy.getMinDistanceToPickUp();
        }
        return (Integer)SoundAttractConfig.COMMON.pickUpMinDistanceToPickUp.get();
    }

    public static int getPickUpMaxDistanceToThrow() {
        if (IS_ENHANCED_AI_LOADED) {
            return PickUpProxy.getMaxDistanceToThrow();
        }
        return (Integer)SoundAttractConfig.COMMON.pickUpMaxDistanceToThrow.get();
    }

    public static double getPickUpSpeedModifier() {
        if (IS_ENHANCED_AI_LOADED) {
            return PickUpProxy.getSpeedModifier();
        }
        return (Double)SoundAttractConfig.COMMON.pickUpSpeedModifier.get();
    }

    public static int getPickUpCooldownTicks() {
        if (IS_ENHANCED_AI_LOADED) {
            return PickUpProxy.getCooldown();
        }
        return (Integer)SoundAttractConfig.COMMON.pickUpCooldownTicks.get();
    }

    public static boolean isEnhancedAiLoaded() {
        return IS_ENHANCED_AI_LOADED;
    }

    public static double getXrayAttributeValue(Mob mob) {
        if (!IS_ENHANCED_AI_LOADED || mob == null) {
            return 0.0;
        }
        try {
            return XrayProxy.getXrayFollowRange(mob);
        }
        catch (Throwable t) {
            return 0.0;
        }
    }

    private static class MinerMobsProxy {
        private MinerMobsProxy() {
        }

        static int getMaxY() {
            return MinerMobs.maxY;
        }

        static boolean blacklistTileEntities() {
            return MinerMobs.blacklistTileEntities;
        }

        static boolean isBlacklistAsWhitelist() {
            return MinerMobs.blockBlacklistAsWhitelist;
        }

        static TagKey<Block> getBlockBlacklistTag() {
            return MinerMobs.BLOCK_BLACKLIST;
        }
    }

    private static class TeleportProxy {
        private TeleportProxy() {
        }

        static double getChance(Level level) {
            return TeleportToTarget.chance.getByDifficulty(level);
        }

        static int getCooldown() {
            return TeleportToTarget.cooldown;
        }
    }

    private static class PickUpProxy {
        private PickUpProxy() {
        }

        static double getChance(Level level) {
            return PickUpAndThrow.chance.getByDifficulty(level);
        }

        static int getMinDistanceToPickUp() {
            return PickUpAndThrow.minDistanceToPickUp;
        }

        static int getMaxDistanceToThrow() {
            return PickUpAndThrow.maxDistanceToThrow;
        }

        static double getSpeedModifier() {
            return PickUpAndThrow.speedModifierToPickUp;
        }

        static int getCooldown() {
            return PickUpAndThrow.cooldown;
        }
    }

    private static class XrayProxy {
        private XrayProxy() {
        }

        static double getXrayFollowRange(Mob mob) {
            AttributeInstance inst = mob.m_21051_((Attribute)EAIAttributes.XRAY_FOLLOW_RANGE.get());
            if (inst == null) {
                return 0.0;
            }
            double v = inst.m_22115_();
            if (v <= 0.0) {
                v = inst.m_22135_();
            }
            return Math.max(0.0, v);
        }
    }
}

