/*
 * Decompiled with CFR 0.152.
 */
package net.pigling.starlandsdimension.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.pigling.starlandsdimension.procedures.ExplosiveStarBlockDestroyedByExplosionProcedure;
import net.pigling.starlandsdimension.procedures.ExplosiveStarBlockDestroyedByPlayerProcedure;

public class ExplosiveStarBlock
extends Block {
    public ExplosiveStarBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.AMETHYST).strength(1.0f, 10.0f).lightLevel(s -> 1).instrument(NoteBlockInstrument.BASEDRUM));
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 15;
    }

    public boolean onDestroyedByPlayer(BlockState blockstate, Level world, BlockPos pos, Player entity, boolean willHarvest, FluidState fluid) {
        boolean retval = super.onDestroyedByPlayer(blockstate, world, pos, entity, willHarvest, fluid);
        ExplosiveStarBlockDestroyedByPlayerProcedure.execute((Entity)entity);
        return retval;
    }

    public void onProjectileHit(Level world, BlockState blockstate, BlockHitResult hit, Projectile entity) {
        ExplosiveStarBlockDestroyedByExplosionProcedure.execute((LevelAccessor)world, hit.getBlockPos().getX(), hit.getBlockPos().getY(), hit.getBlockPos().getZ(), (Entity)entity);
    }
}

