/*
 * Decompiled with CFR 0.152.
 */
package net.pigling.starlandsdimension.fluid;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.pigling.starlandsdimension.init.StarlandsdimensionModBlocks;
import net.pigling.starlandsdimension.init.StarlandsdimensionModFluidTypes;
import net.pigling.starlandsdimension.init.StarlandsdimensionModFluids;
import net.pigling.starlandsdimension.init.StarlandsdimensionModItems;

public abstract class StarSauceFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)StarlandsdimensionModFluidTypes.STAR_SAUCE_TYPE.get(), () -> (Fluid)StarlandsdimensionModFluids.STAR_SAUCE.get(), () -> (Fluid)StarlandsdimensionModFluids.FLOWING_STAR_SAUCE.get()).explosionResistance(100.0f).bucket(() -> (Item)StarlandsdimensionModItems.STAR_SAUCE_BUCKET.get()).block(() -> (LiquidBlock)StarlandsdimensionModBlocks.STAR_SAUCE.get());

    private StarSauceFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.FALLING_WATER;
    }

    public static class Flowing
    extends StarSauceFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends StarSauceFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

