/*
 * Decompiled with CFR 0.152.
 */
package net.pigling.starlandsdimension.fluid.types;

import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidType;
import net.pigling.starlandsdimension.init.StarlandsdimensionModFluidTypes;

@EventBusSubscriber
public class StarSauceFluidType
extends FluidType {
    public StarSauceFluidType() {
        super(FluidType.Properties.create().fallDistanceModifier(0.0f).canExtinguish(true).supportsBoating(true).canHydrate(true).motionScale(0.007).canConvertToSource(true).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"item.bucket.empty"))).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH));
    }

    @SubscribeEvent
    public static void registerFluidTypeExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final ResourceLocation STILL_TEXTURE = ResourceLocation.parse((String)"starlandsdimension:block/sauceflow");
            private static final ResourceLocation FLOWING_TEXTURE = ResourceLocation.parse((String)"starlandsdimension:block/saucestill");

            public ResourceLocation getStillTexture() {
                return STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOWING_TEXTURE;
            }

            public int getTintColor() {
                return -13083194;
            }

            public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
                return BiomeColors.getAverageWaterColor((BlockAndTintGetter)world, (BlockPos)pos) | 0xFF000000;
            }
        }, new FluidType[]{(FluidType)StarlandsdimensionModFluidTypes.STAR_SAUCE_TYPE.get()});
    }
}

