/*
 * Decompiled with CFR 0.152.
 */
package net.pigling.starlandsdimension.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.pigling.starlandsdimension.entity.CorrrEntity;
import net.pigling.starlandsdimension.entity.CorruptStarCoreEntity;
import net.pigling.starlandsdimension.entity.CosmicProwlerEntity;
import net.pigling.starlandsdimension.entity.CosmosFishEntity;
import net.pigling.starlandsdimension.entity.FrostShotEntity;
import net.pigling.starlandsdimension.entity.LightningCoreEntity;
import net.pigling.starlandsdimension.entity.MoonlightFloaterEntity;
import net.pigling.starlandsdimension.entity.OmniCoreProjctileEntity;
import net.pigling.starlandsdimension.entity.RevokerEntity;
import net.pigling.starlandsdimension.entity.SpecteralCluckshroomEntity;
import net.pigling.starlandsdimension.entity.WandProjectileEntity;

@EventBusSubscriber
public class StarlandsdimensionModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"starlandsdimension");
    public static final DeferredHolder<EntityType<?>, EntityType<CosmosFishEntity>> COSMOS_FISH = StarlandsdimensionModEntities.register("cosmos_fish", EntityType.Builder.of(CosmosFishEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.5f, 0.3f));
    public static final DeferredHolder<EntityType<?>, EntityType<WandProjectileEntity>> WAND_PROJECTILE = StarlandsdimensionModEntities.register("wand_projectile", EntityType.Builder.of(WandProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<FrostShotEntity>> FROST_SHOT = StarlandsdimensionModEntities.register("frost_shot", EntityType.Builder.of(FrostShotEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<LightningCoreEntity>> LIGHTNING_CORE = StarlandsdimensionModEntities.register("lightning_core", EntityType.Builder.of(LightningCoreEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<CosmicProwlerEntity>> COSMIC_PROWLER = StarlandsdimensionModEntities.register("cosmic_prowler", EntityType.Builder.of(CosmicProwlerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 0.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<CorrrEntity>> CORRR = StarlandsdimensionModEntities.register("corrr", EntityType.Builder.of(CorrrEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<MoonlightFloaterEntity>> MOONLIGHT_FLOATER = StarlandsdimensionModEntities.register("moonlight_floater", EntityType.Builder.of(MoonlightFloaterEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.0f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<SpecteralCluckshroomEntity>> SPECTERAL_CLUCKSHROOM = StarlandsdimensionModEntities.register("specteral_cluckshroom", EntityType.Builder.of(SpecteralCluckshroomEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.4f, 0.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<CorruptStarCoreEntity>> CORRUPT_STAR_CORE = StarlandsdimensionModEntities.register("corrupt_star_core", EntityType.Builder.of(CorruptStarCoreEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<RevokerEntity>> REVOKER = StarlandsdimensionModEntities.register("revoker", EntityType.Builder.of(RevokerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.95f));
    public static final DeferredHolder<EntityType<?>, EntityType<OmniCoreProjctileEntity>> OMNI_CORE_PROJCTILE = StarlandsdimensionModEntities.register("omni_core_projctile", EntityType.Builder.of(OmniCoreProjctileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        CosmosFishEntity.init(event);
        CosmicProwlerEntity.init(event);
        MoonlightFloaterEntity.init(event);
        SpecteralCluckshroomEntity.init(event);
        RevokerEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)COSMOS_FISH.get(), CosmosFishEntity.createAttributes().build());
        event.put((EntityType)COSMIC_PROWLER.get(), CosmicProwlerEntity.createAttributes().build());
        event.put((EntityType)MOONLIGHT_FLOATER.get(), MoonlightFloaterEntity.createAttributes().build());
        event.put((EntityType)SPECTERAL_CLUCKSHROOM.get(), SpecteralCluckshroomEntity.createAttributes().build());
        event.put((EntityType)REVOKER.get(), RevokerEntity.createAttributes().build());
    }
}

