/*
 * Decompiled with CFR 0.152.
 */
package net.pigling.starlandsdimension.network;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.pigling.starlandsdimension.StarlandsdimensionMod;
import net.pigling.starlandsdimension.procedures.NetherFurnaceGUICodeProcedure;
import net.pigling.starlandsdimension.world.inventory.NetherFurnaceGUIMenu;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record NetherFurnaceGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<NetherFurnaceGUIButtonMessage> TYPE = new CustomPacketPayload.Type(new ResourceLocation("starlandsdimension", "nether_furnace_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, NetherFurnaceGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new NetherFurnaceGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<NetherFurnaceGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(NetherFurnaceGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                NetherFurnaceGUIButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = NetherFurnaceGUIMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            NetherFurnaceGUICodeProcedure.execute();
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        StarlandsdimensionMod.addNetworkMessage(TYPE, STREAM_CODEC, NetherFurnaceGUIButtonMessage::handleData);
    }
}

