/*
 * Decompiled with CFR 0.152.
 */
package net.pigling.starlandsdimension.world.teleporter;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.BlockUtil;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.ITeleporter;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.pigling.starlandsdimension.init.StarlandsdimensionModBlocks;
import net.pigling.starlandsdimension.world.teleporter.TheStarlandsPortalShape;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class TheStarlandsTeleporter
implements ITeleporter {
    public static final TicketType<BlockPos> CUSTOM_PORTAL = TicketType.create((String)"the_starlands_portal", Vec3i::compareTo, (int)300);
    public static Holder<PoiType> poi = null;
    private final ServerLevel level;
    private final BlockPos entityEnterPos;

    @SubscribeEvent
    public static void registerPointOfInterest(RegisterEvent event) {
        event.register(Registries.POINT_OF_INTEREST_TYPE, registerHelper -> {
            PoiType poiType = new PoiType((Set)ImmutableSet.copyOf((Collection)((Block)StarlandsdimensionModBlocks.THE_STARLANDS_PORTAL.get()).getStateDefinition().getPossibleStates()), 0, 1);
            registerHelper.register(new ResourceLocation("starlandsdimension:the_starlands_portal"), (Object)poiType);
            poi = BuiltInRegistries.POINT_OF_INTEREST_TYPE.wrapAsHolder((Object)poiType);
        });
    }

    public TheStarlandsTeleporter(ServerLevel worldServer, BlockPos entityEnterPos) {
        this.level = worldServer;
        this.entityEnterPos = entityEnterPos;
    }

    public Optional<BlockUtil.FoundRectangle> findPortalAround(BlockPos p_192986_, boolean p_192987_, WorldBorder p_192988_) {
        PoiManager poimanager = this.level.getPoiManager();
        int i = p_192987_ ? 16 : 128;
        poimanager.ensureLoadedAndValid((LevelReader)this.level, p_192986_, i);
        Optional<PoiRecord> optional = poimanager.getInSquare(p_230634_ -> p_230634_.is((ResourceKey)poi.unwrapKey().get()), p_192986_, i, PoiManager.Occupancy.ANY).filter(p_192981_ -> p_192988_.isWithinBounds(p_192981_.getPos())).sorted(Comparator.comparingDouble(p_192984_ -> p_192984_.getPos().distSqr((Vec3i)p_192986_)).thenComparingInt(p_192992_ -> p_192992_.getPos().getY())).filter(p_192990_ -> this.level.getBlockState(p_192990_.getPos()).hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)).findFirst();
        return optional.map(p_192975_ -> {
            BlockPos blockpos = p_192975_.getPos();
            this.level.getChunkSource().addRegionTicket(CUSTOM_PORTAL, new ChunkPos(blockpos), 3, (Object)blockpos);
            BlockState blockstate = this.level.getBlockState(blockpos);
            return BlockUtil.getLargestRectangleAround((BlockPos)blockpos, (Direction.Axis)((Direction.Axis)blockstate.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, p_192978_ -> this.level.getBlockState(p_192978_) == blockstate);
        });
    }

    public Optional<BlockUtil.FoundRectangle> createPortal(BlockPos p_77667_, Direction.Axis p_77668_) {
        Direction direction = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)p_77668_);
        double d0 = -1.0;
        BlockPos blockpos = null;
        double d1 = -1.0;
        BlockPos blockpos1 = null;
        WorldBorder worldborder = this.level.getWorldBorder();
        int i = Math.min(this.level.getMaxBuildHeight(), this.level.getMinBuildHeight() + this.level.getLogicalHeight()) - 1;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_77667_.mutable();
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos1 : BlockPos.spiralAround((BlockPos)p_77667_, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int j = Math.min(i, this.level.getHeight(Heightmap.Types.MOTION_BLOCKING, blockpos$mutableblockpos1.getX(), blockpos$mutableblockpos1.getZ()));
            boolean k = true;
            if (!worldborder.isWithinBounds((BlockPos)blockpos$mutableblockpos1) || !worldborder.isWithinBounds((BlockPos)blockpos$mutableblockpos1.move(direction, 1))) continue;
            blockpos$mutableblockpos1.move(direction.getOpposite(), 1);
            for (int l = j; l >= this.level.getMinBuildHeight(); --l) {
                int j1;
                blockpos$mutableblockpos1.setY(l);
                if (!this.canPortalReplaceBlock(blockpos$mutableblockpos1)) continue;
                int i1 = l;
                while (l > this.level.getMinBuildHeight() && this.canPortalReplaceBlock(blockpos$mutableblockpos1.move(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > i || (j1 = i1 - l) > 0 && j1 < 3) continue;
                blockpos$mutableblockpos1.setY(l);
                if (!this.canHostFrame((BlockPos)blockpos$mutableblockpos1, blockpos$mutableblockpos, direction, 0)) continue;
                double d2 = p_77667_.distSqr((Vec3i)blockpos$mutableblockpos1);
                if (this.canHostFrame((BlockPos)blockpos$mutableblockpos1, blockpos$mutableblockpos, direction, -1) && this.canHostFrame((BlockPos)blockpos$mutableblockpos1, blockpos$mutableblockpos, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockpos = blockpos$mutableblockpos1.immutable();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockpos1 = blockpos$mutableblockpos1.immutable();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
            d0 = d1;
        }
        if (d0 == -1.0) {
            int i2 = i - 9;
            int k1 = Math.max(this.level.getMinBuildHeight() - -1, 70);
            if (i2 < k1) {
                return Optional.empty();
            }
            blockpos = new BlockPos(p_77667_.getX(), Mth.clamp((int)p_77667_.getY(), (int)k1, (int)i2), p_77667_.getZ()).immutable();
            Direction direction1 = direction.getClockWise();
            if (!worldborder.isWithinBounds(blockpos)) {
                return Optional.empty();
            }
            for (int i3 = -1; i3 < 2; ++i3) {
                for (int j3 = 0; j3 < 2; ++j3) {
                    for (int k3 = -1; k3 < 3; ++k3) {
                        BlockState blockstate1 = k3 < 0 ? ((Block)StarlandsdimensionModBlocks.PORTAL.get()).defaultBlockState() : Blocks.AIR.defaultBlockState();
                        blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, j3 * direction.getStepX() + i3 * direction1.getStepX(), k3, j3 * direction.getStepZ() + i3 * direction1.getStepZ());
                        this.level.setBlockAndUpdate((BlockPos)blockpos$mutableblockpos, blockstate1);
                    }
                }
            }
        }
        for (int l1 = -1; l1 < 3; ++l1) {
            for (int j2 = -1; j2 < 4; ++j2) {
                if (l1 != -1 && l1 != 2 && j2 != -1 && j2 != 3) continue;
                blockpos$mutableblockpos.setWithOffset(blockpos, l1 * direction.getStepX(), j2, l1 * direction.getStepZ());
                this.level.setBlock((BlockPos)blockpos$mutableblockpos, ((Block)StarlandsdimensionModBlocks.PORTAL.get()).defaultBlockState(), 3);
            }
        }
        BlockState blockstate = (BlockState)((Block)StarlandsdimensionModBlocks.THE_STARLANDS_PORTAL.get()).defaultBlockState().setValue((Property)NetherPortalBlock.AXIS, (Comparable)p_77668_);
        for (int k2 = 0; k2 < 2; ++k2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, k2 * direction.getStepX(), l2, k2 * direction.getStepZ());
                this.level.setBlock((BlockPos)blockpos$mutableblockpos, blockstate, 18);
                this.level.getPoiManager().add((BlockPos)blockpos$mutableblockpos, poi);
            }
        }
        return Optional.of(new BlockUtil.FoundRectangle(blockpos.immutable(), 2, 3));
    }

    private boolean canHostFrame(BlockPos p_77662_, BlockPos.MutableBlockPos p_77663_, Direction p_77664_, int p_77665_) {
        Direction direction = p_77664_.getClockWise();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                p_77663_.setWithOffset((Vec3i)p_77662_, p_77664_.getStepX() * i + direction.getStepX() * p_77665_, j, p_77664_.getStepZ() * i + direction.getStepZ() * p_77665_);
                if (j < 0 && !this.level.getBlockState((BlockPos)p_77663_).isSolid()) {
                    return false;
                }
                if (j < 0 || this.canPortalReplaceBlock(p_77663_)) continue;
                return false;
            }
        }
        return true;
    }

    public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel server, float yaw, Function<Boolean, Entity> repositionEntity) {
        PortalInfo portalinfo = this.getPortalInfo(entity, server);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.setServerLevel(server);
            server.addDuringPortalTeleport(player);
            player.connection.teleport(portalinfo.pos.x, portalinfo.pos.y, portalinfo.pos.z, portalinfo.yRot, portalinfo.xRot);
            player.connection.resetPosition();
            CriteriaTriggers.CHANGED_DIMENSION.trigger(player, currentWorld.dimension(), server.dimension());
            return entity;
        }
        Entity entityNew = entity.getType().create((Level)server);
        if (entityNew != null) {
            entityNew.restoreFrom(entity);
            entityNew.moveTo(portalinfo.pos.x, portalinfo.pos.y, portalinfo.pos.z, portalinfo.yRot, entityNew.getXRot());
            entityNew.setDeltaMovement(portalinfo.speed);
            server.addDuringTeleport(entityNew);
        }
        return entityNew;
    }

    private PortalInfo getPortalInfo(Entity entity, ServerLevel server) {
        WorldBorder worldborder = server.getWorldBorder();
        double d0 = DimensionType.getTeleportationScale((DimensionType)entity.level().dimensionType(), (DimensionType)server.dimensionType());
        BlockPos blockpos1 = worldborder.clampToBounds(entity.getX() * d0, entity.getY(), entity.getZ() * d0);
        return this.getExitPortal(entity, blockpos1, worldborder).map(repositioner -> {
            Vec3 vector3d;
            Direction.Axis direction$axis;
            BlockState blockstate = entity.level().getBlockState(this.entityEnterPos);
            if (blockstate.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
                direction$axis = (Direction.Axis)blockstate.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
                BlockUtil.FoundRectangle teleportationrepositioner$result = BlockUtil.getLargestRectangleAround((BlockPos)this.entityEnterPos, (Direction.Axis)direction$axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, pos -> entity.level().getBlockState(pos) == blockstate);
                vector3d = TheStarlandsPortalShape.getRelativePosition(teleportationrepositioner$result, direction$axis, entity.position(), entity.getDimensions(entity.getPose()));
            } else {
                direction$axis = Direction.Axis.X;
                vector3d = new Vec3(0.5, 0.0, 0.0);
            }
            return TheStarlandsPortalShape.createPortalInfo(server, repositioner, direction$axis, vector3d, entity, entity.getDeltaMovement(), entity.getYRot(), entity.getXRot());
        }).orElse(new PortalInfo(entity.position(), Vec3.ZERO, entity.getYRot(), entity.getXRot()));
    }

    protected Optional<BlockUtil.FoundRectangle> getExitPortal(Entity entity, BlockPos pos, WorldBorder worldBorder) {
        Optional<BlockUtil.FoundRectangle> optional = this.findPortalAround(pos, false, worldBorder);
        if (entity instanceof ServerPlayer) {
            if (optional.isPresent()) {
                return optional;
            }
            Direction.Axis direction$axis = entity.level().getBlockState(this.entityEnterPos).getOptionalValue((Property)NetherPortalBlock.AXIS).orElse(Direction.Axis.X);
            return this.createPortal(pos, direction$axis);
        }
        return optional;
    }

    private boolean canPortalReplaceBlock(BlockPos.MutableBlockPos pos) {
        BlockState blockstate = this.level.getBlockState((BlockPos)pos);
        return blockstate.canBeReplaced() && blockstate.getFluidState().isEmpty();
    }
}

