/*
 * Decompiled with CFR 0.152.
 */
package net.pigling.starlandsdimension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.handling.IPlayPayloadHandler;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import net.pigling.starlandsdimension.init.StarlandsdimensionModBlocks;
import net.pigling.starlandsdimension.init.StarlandsdimensionModEntities;
import net.pigling.starlandsdimension.init.StarlandsdimensionModFluidTypes;
import net.pigling.starlandsdimension.init.StarlandsdimensionModFluids;
import net.pigling.starlandsdimension.init.StarlandsdimensionModItems;
import net.pigling.starlandsdimension.init.StarlandsdimensionModMenus;
import net.pigling.starlandsdimension.init.StarlandsdimensionModMobEffects;
import net.pigling.starlandsdimension.init.StarlandsdimensionModPotions;
import net.pigling.starlandsdimension.init.StarlandsdimensionModSounds;
import net.pigling.starlandsdimension.init.StarlandsdimensionModTabs;
import net.pigling.starlandsdimension.init.StarlandsdimensionModVillagerProfessions;
import net.pigling.starlandsdimension.network.StarlandsdimensionModVariables;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="starlandsdimension")
public class StarlandsdimensionMod {
    public static final Logger LOGGER = LogManager.getLogger(StarlandsdimensionMod.class);
    public static final String MODID = "starlandsdimension";
    private static boolean networkingRegistered = false;
    private static final Map<ResourceLocation, NetworkMessage<?>> MESSAGES = new HashMap();
    private static final Collection<Tuple<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<Tuple<Runnable, Integer>>();

    public StarlandsdimensionMod(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::registerNetworking);
        StarlandsdimensionModSounds.REGISTRY.register(modEventBus);
        StarlandsdimensionModBlocks.REGISTRY.register(modEventBus);
        StarlandsdimensionModItems.register(modEventBus);
        StarlandsdimensionModEntities.REGISTRY.register(modEventBus);
        StarlandsdimensionModTabs.REGISTRY.register(modEventBus);
        StarlandsdimensionModVariables.ATTACHMENT_TYPES.register(modEventBus);
        StarlandsdimensionModPotions.REGISTRY.register(modEventBus);
        StarlandsdimensionModMobEffects.REGISTRY.register(modEventBus);
        StarlandsdimensionModMenus.REGISTRY.register(modEventBus);
        StarlandsdimensionModVillagerProfessions.PROFESSIONS.register(modEventBus);
        StarlandsdimensionModFluids.REGISTRY.register(modEventBus);
        StarlandsdimensionModFluidTypes.REGISTRY.register(modEventBus);
    }

    public static <T extends CustomPacketPayload> void addNetworkMessage(ResourceLocation id, FriendlyByteBuf.Reader<T> reader, IPlayPayloadHandler<T> handler) {
        if (networkingRegistered) {
            throw new IllegalStateException("Cannot register new network messages after networking has been registered");
        }
        MESSAGES.put(id, new NetworkMessage<T>(reader, handler));
    }

    private void registerNetworking(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar(MODID);
        MESSAGES.forEach((id, networkMessage) -> registrar.play(id, networkMessage.reader(), networkMessage.handler()));
        networkingRegistered = true;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add((Tuple<Runnable, Integer>)new Tuple((Object)action, (Object)tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setB((Object)((Integer)work.getB() - 1));
                if ((Integer)work.getB() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getA()).run());
            workQueue.removeAll(actions);
        }
    }

    private record NetworkMessage<T extends CustomPacketPayload>(FriendlyByteBuf.Reader<T> reader, IPlayPayloadHandler<T> handler) {
    }
}

