/*
 * Decompiled with CFR 0.152.
 */
package net.pigling.starlandsdimension.item;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.pigling.starlandsdimension.block.TheStarlandsPortalBlock;

public class TheStarlandsItem
extends Item {
    public TheStarlandsItem() {
        super(new Item.Properties().rarity(Rarity.RARE).durability(64));
    }

    public InteractionResult useOn(UseOnContext context) {
        Player entity = context.getPlayer();
        BlockPos pos = context.getClickedPos().relative(context.getClickedFace());
        ItemStack itemstack = context.getItemInHand();
        Level world = context.getLevel();
        if (!entity.mayUseItemAt(pos, context.getClickedFace(), itemstack)) {
            return InteractionResult.FAIL;
        }
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        boolean success = false;
        if (world.isEmptyBlock(pos)) {
            TheStarlandsPortalBlock.portalSpawn(world, pos);
            itemstack.hurtAndBreak(1, (LivingEntity)entity, c -> c.broadcastBreakEvent(context.getHand()));
            success = true;
        }
        return success ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }
}

