/*
 * Decompiled with CFR 0.152.
 */
package net.pigling.starlandsdimension.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.pigling.starlandsdimension.init.StarlandsdimensionModBlocks;
import net.pigling.starlandsdimension.procedures.CosmicSaplingOnTickUpdateProcedure;

public class CosmicSaplingBlock
extends FlowerBlock {
    public CosmicSaplingBlock(BlockBehaviour.Properties properties) {
        super(MobEffects.MOVEMENT_SPEED, 100.0f, properties.mapColor(MapColor.PLANT).randomTicks().sound(SoundType.GRASS).instabreak().noCollission().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public boolean mayPlaceOn(BlockState groundState, BlockGetter worldIn, BlockPos pos) {
        return groundState.is((Block)StarlandsdimensionModBlocks.SWAMPY_GRASS.get()) || groundState.is((Block)StarlandsdimensionModBlocks.STARBLOCK.get()) || groundState.is((Block)StarlandsdimensionModBlocks.TOP_SOIL.get()) || groundState.is((Block)StarlandsdimensionModBlocks.STAR_SNOW.get()) || groundState.is((Block)StarlandsdimensionModBlocks.LIVELY_GRASS.get()) || groundState.is((Block)StarlandsdimensionModBlocks.WHEATGRASS.get()) || groundState.is((Block)StarlandsdimensionModBlocks.RED_GRASS.get());
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState groundState = worldIn.getBlockState(blockpos);
        return this.mayPlaceOn(groundState, (BlockGetter)worldIn, blockpos);
    }

    public void randomTick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        CosmicSaplingOnTickUpdateProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }
}

