/*
 * Decompiled with CFR 0.152.
 */
package net.pigling.starlandsdimension.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.pigling.starlandsdimension.procedures.BlockPlacerChallengeNeighbourBlockChangesProcedure;
import net.pigling.starlandsdimension.procedures.BlockPlacerChallengeOnBlockRightClickedProcedure;

public class BlockPlacerChallengeBlock
extends Block {
    public BlockPlacerChallengeBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.GOLD).sound(SoundType.COPPER).strength(-1.0f, 3600000.0f).instrument(NoteBlockInstrument.BASEDRUM));
    }

    public int getLightBlock(BlockState state) {
        return 15;
    }

    public void neighborChanged(BlockState blockstate, Level world, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean moving) {
        super.neighborChanged(blockstate, world, pos, neighborBlock, orientation, moving);
        BlockPlacerChallengeNeighbourBlockChangesProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        BlockPlacerChallengeOnBlockRightClickedProcedure.execute((LevelAccessor)world);
        return InteractionResult.SUCCESS;
    }
}

