/*
 * Decompiled with CFR 0.152.
 */
package net.pigling.starlandsdimension.client.fluid;

import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.pigling.starlandsdimension.init.StarlandsdimensionModFluidTypes;

@EventBusSubscriber(value={Dist.CLIENT})
public class StarSauceFluidExtension {
    @SubscribeEvent
    public static void registerFluidTypeExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final ResourceLocation STILL_TEXTURE = ResourceLocation.parse((String)"starlandsdimension:block/sauceflow");
            private static final ResourceLocation FLOWING_TEXTURE = ResourceLocation.parse((String)"starlandsdimension:block/saucestill");

            public ResourceLocation getStillTexture() {
                return STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOWING_TEXTURE;
            }

            public int getTintColor() {
                return -13083194;
            }

            public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
                return BiomeColors.getAverageWaterColor((BlockAndTintGetter)world, (BlockPos)pos) | 0xFF000000;
            }
        }, new FluidType[]{(FluidType)StarlandsdimensionModFluidTypes.STAR_SAUCE_TYPE.get()});
    }
}

