/*
 * Decompiled with CFR 0.152.
 */
package net.pigling.starlandsdimension.recipe.brewing;

import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.pigling.starlandsdimension.init.StarlandsdimensionModItems;
import net.pigling.starlandsdimension.init.StarlandsdimensionModPotions;

@EventBusSubscriber
public class PotionOfEnlighteningBrewingRecipe
implements IBrewingRecipe {
    @SubscribeEvent
    public static void init(RegisterBrewingRecipesEvent event) {
        event.getBuilder().addRecipe((IBrewingRecipe)new PotionOfEnlighteningBrewingRecipe());
    }

    public boolean isInput(ItemStack input) {
        Item inputItem = input.getItem();
        return (inputItem == Items.POTION || inputItem == Items.SPLASH_POTION || inputItem == Items.LINGERING_POTION) && ((PotionContents)input.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).is(Potions.AWKWARD);
    }

    public boolean isIngredient(ItemStack ingredient) {
        return Ingredient.of((ItemLike)((ItemLike)StarlandsdimensionModItems.COSMOS_FISH_FIN.get())).test(ingredient);
    }

    public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
        if (this.isInput(input) && this.isIngredient(ingredient)) {
            return PotionContents.createItemStack((Item)input.getItem(), StarlandsdimensionModPotions.ENLIGHTENING);
        }
        return ItemStack.EMPTY;
    }
}

