package fr.solmey.clienthings.mixin;

import fr.solmey.clienthings.util.BurpToCancel;


import java.util.List;
import net.minecraft.class_10124;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_746.class)
public class ClientPlayerEntityMixin {
	@Inject(at = @At("HEAD"), method = "tick")
	private void tick(CallbackInfo info) {
		class_746 player = (class_746)(Object) this;

		class_1799 itemStack = player.method_6030();
		class_10124 consumableComponent = itemStack.method_58694(class_9334.field_53964);

		if(player.method_6014() <= 0 && consumableComponent != null && itemStack != null) {
			class_3414 sound = null;
			class_5819 random = player.method_59922();
			sound = class_3417.field_19149; // fixes a bug lol 
			// https://bugs.mojang.com/browse/MC/issues/MC-188359 btw

			player.method_37908().method_8486(player.method_23317(), player.method_23318(), player.method_23321(), sound, class_3419.field_15248, 0.5F, class_3532.method_32750(random, 0.9F, 1.0F), true);

			for (int i = 0; i < 257; i++) {
				if (i >= 256) {
					BurpToCancel.set(0, System.currentTimeMillis(), player.method_23317(), player.method_23318(), player.method_23321());
					break;
				}
				if (BurpToCancel.timestamps[i] == 0) {
					BurpToCancel.set(i, System.currentTimeMillis(), player.method_23317(), player.method_23318(), player.method_23321());
					break;
				}
			}

			((LivingEntityInvoker) player).invokeConsumeItem();
            consumableComponent.comp_3089().forEach(effect -> effect.method_62866(player.method_37908(), itemStack, player));
		}
	}
}

@Mixin(class_1309.class)
interface LivingEntityInvoker {

    @Invoker("consumeItem")
    void invokeConsumeItem();
}