/*
 * Decompiled with CFR 0.152.
 */
package me.vovchikcraft.namelore;

import java.util.List;
import me.vovchikcraft.namelore.NameLore;
import me.vovchikcraft.namelore.Utils;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class Commands
implements CommandExecutor {
    private final NameLore plugin;

    public Commands(NameLore nameLore) {
        this.plugin = nameLore;
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage("Only players can use this command!");
            return true;
        }
        Player player = (Player)commandSender;
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (itemStack == null || itemStack.getType().isAir()) {
            player.sendMessage(this.plugin.getConfig().getString("Messages.no-item", "You must hold an item to do that!"));
            return true;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return true;
        }
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)this.plugin, "locked");
        if (command.getName().equalsIgnoreCase("nl")) {
            if (stringArray.length < 2) {
                player.sendMessage(this.plugin.getConfig().getString("Messages.invalid-command", "This command does not exist!"));
                return true;
            }
            String string2 = stringArray[0].toLowerCase();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder.append(stringArray[i]).append(" ");
            }
            String string3 = stringBuilder.toString().trim();
            int n = this.plugin.getConfig().getInt("Limits.MaxNameChars", 50);
            int n2 = this.plugin.getConfig().getInt("Limits.MaxLoreChars", 100);
            List list = this.plugin.getConfig().getStringList("BannedWords");
            if (itemMeta.getPersistentDataContainer().has(namespacedKey, PersistentDataType.BYTE)) {
                player.sendMessage(this.plugin.getConfig().getString("Messages.locked", "This item is locked and cannot be modified!"));
                return true;
            }
            if (string2.equals("rename")) {
                if (Utils.containsBannedWord(string3, list)) {
                    player.sendMessage(this.plugin.getConfig().getString("Messages.banned-word", "Your text contains a banned word!"));
                    return true;
                }
                if (Utils.isTooLong(string3, n)) {
                    player.sendMessage(this.plugin.getConfig().getString("Messages.too-long", "Too many characters! Write less!"));
                    return true;
                }
                itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)string3));
                itemStack.setItemMeta(itemMeta);
                player.sendMessage(this.plugin.getConfig().getString("Messages.success", "Operation completed successfully!"));
                return true;
            }
            if (string2.equals("relore")) {
                if (Utils.containsBannedWord(string3, list)) {
                    player.sendMessage(this.plugin.getConfig().getString("Messages.banned-word", "Your text contains a banned word!"));
                    return true;
                }
                if (Utils.isTooLong(string3, n2)) {
                    player.sendMessage(this.plugin.getConfig().getString("Messages.too-long", "Too many characters! Write less!"));
                    return true;
                }
                itemMeta.setLore(List.of(ChatColor.translateAlternateColorCodes((char)'&', (String)string3)));
                itemStack.setItemMeta(itemMeta);
                player.sendMessage(this.plugin.getConfig().getString("Messages.success", "Operation completed successfully!"));
                return true;
            }
            player.sendMessage(this.plugin.getConfig().getString("Messages.invalid-command", "This command does not exist!"));
            return true;
        }
        if (command.getName().equalsIgnoreCase("nla")) {
            String string4;
            if (stringArray.length < 1) {
                player.sendMessage(this.plugin.getConfig().getString("Messages.invalid-command", "This command does not exist!"));
                return true;
            }
            switch (string4 = stringArray[0].toLowerCase()) {
                case "lock": {
                    itemMeta.getPersistentDataContainer().set(namespacedKey, PersistentDataType.BYTE, (Object)1);
                    itemStack.setItemMeta(itemMeta);
                    player.sendMessage(this.plugin.getConfig().getString("Messages.locked", "This item is locked and cannot be modified!"));
                    return true;
                }
                case "dellock": {
                    itemMeta.getPersistentDataContainer().remove(namespacedKey);
                    itemStack.setItemMeta(itemMeta);
                    player.sendMessage(this.plugin.getConfig().getString("Messages.unlocked", "The item is now unlocked."));
                    return true;
                }
                case "delrename": {
                    itemMeta.setDisplayName(null);
                    itemStack.setItemMeta(itemMeta);
                    player.sendMessage(this.plugin.getConfig().getString("Messages.success", "Operation completed successfully!"));
                    return true;
                }
                case "delrelore": {
                    itemMeta.setLore(null);
                    itemStack.setItemMeta(itemMeta);
                    player.sendMessage(this.plugin.getConfig().getString("Messages.success", "Operation completed successfully!"));
                    return true;
                }
            }
            player.sendMessage(this.plugin.getConfig().getString("Messages.invalid-command", "This command does not exist!"));
            return true;
        }
        return true;
    }
}

