/*
 * Decompiled with CFR 0.152.
 */
package net.ppekkungz.essentialUtils;

import net.ppekkungz.essentialUtils.config.PluginConfig;
import net.ppekkungz.essentialUtils.listener.ActivationListener;
import net.ppekkungz.essentialUtils.state.StateManager;
import net.ppekkungz.essentialUtils.work.WorkService;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class EssentialUtils
extends JavaPlugin {
    private static EssentialUtils instance;
    private PluginConfig cfg;
    private StateManager states;
    private WorkService work;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.loadPluginConfig();
        this.states = new StateManager();
        this.work = new WorkService(this, this.cfg, this.states);
        this.getServer().getPluginManager().registerEvents((Listener)new ActivationListener(this, this.cfg, this.states, this.work), (Plugin)this);
        this.getLogger().info("Essential Utils enabled (Folia-safe).");
    }

    public void onDisable() {
        if (this.work != null) {
            this.work.shutdown();
        }
        this.getLogger().info("Essential Utils disabled.");
    }

    public void loadPluginConfig() {
        this.cfg = new PluginConfig(this.getConfig());
    }

    public static EssentialUtils get() {
        return instance;
    }

    public PluginConfig cfg() {
        return this.cfg;
    }

    public StateManager states() {
        return this.states;
    }

    public WorkService work() {
        return this.work;
    }
}

