/*
 * Decompiled with CFR 0.152.
 */
package net.ppekkungz.essentialUtils.config;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;

public class PluginConfig {
    private final FileConfiguration c;

    public PluginConfig(FileConfiguration c) {
        this.c = c;
    }

    public boolean showProgress() {
        return this.c.getBoolean("ui.showProgress", true);
    }

    public String indicatorMode() {
        return this.c.getString("ui.indicator", "actionbar");
    }

    public int perPlayerBudget() {
        return this.c.getInt("performance.perPlayerWorkBudgetPerTick", 60);
    }

    public int idleTimeoutSeconds() {
        return this.c.getInt("performance.idleTimeoutSeconds", 12);
    }

    public boolean treeEnabled() {
        return this.c.getBoolean("features.treeAssist.enabled", true);
    }

    public int treeMaxPerTick() {
        return this.c.getInt("features.treeAssist.maxLogsPerTick", 24);
    }

    public int treeMaxLogs() {
        return this.c.getInt("features.treeAssist.maxLogsPerTree", 160);
    }

    public int treeRadius() {
        return this.c.getInt("features.treeAssist.searchRadius", 6);
    }

    public boolean treeRequireLeaves() {
        return this.c.getBoolean("features.treeAssist.requireLeavesNearby", true);
    }

    public boolean treeIncludeStripped() {
        return this.c.getBoolean("features.treeAssist.includeStrippedLogs", true);
    }

    public boolean treeReplantEnabled() {
        return this.c.getBoolean("features.treeAssist.replant.enabled", true);
    }

    public boolean treeReplantRequireInventory() {
        return this.c.getBoolean("features.treeAssist.replant.requireSaplingInInventory", false);
    }

    public int treeReplantRetryCooldownTicks() {
        return this.c.getInt("features.treeAssist.replant.retryCooldownTicks", 5);
    }

    public int treeReplantMaxRetries() {
        return this.c.getInt("features.treeAssist.replant.maxRetries", 10);
    }

    public Set<Material> treeAllowedSoils() {
        List raw = this.c.getStringList("features.treeAssist.replant.allowedSoils");
        HashSet<Material> out = new HashSet<Material>();
        for (String s : raw) {
            try {
                out.add(Material.valueOf((String)s));
            }
            catch (Exception exception) {}
        }
        return out;
    }

    public boolean veinEnabled() {
        return this.c.getBoolean("features.veinMine.enabled", true);
    }

    public int veinMaxPerTick() {
        return this.c.getInt("features.veinMine.maxPerTick", 32);
    }

    public int veinMaxOres() {
        return this.c.getInt("features.veinMine.maxOresPerVein", 128);
    }

    public boolean veinIncludeVariants() {
        return this.c.getBoolean("features.veinMine.includeVariants", true);
    }

    public List<String> veinWhitelist() {
        return this.c.getStringList("features.veinMine.whitelist");
    }

    public List<String> veinBlacklist() {
        return this.c.getStringList("features.veinMine.blacklist");
    }

    public boolean farmEnabled() {
        return this.c.getBoolean("features.autoFarm.enabled", true);
    }

    public int farmRadius() {
        return this.c.getInt("features.autoFarm.harvestRadius", 4);
    }

    public int farmMaxPerTick() {
        return this.c.getInt("features.autoFarm.maxCropsPerTick", 40);
    }

    public List<String> farmWhitelist() {
        return this.c.getStringList("features.autoFarm.cropsWhitelist");
    }

    public List<String> farmBlacklist() {
        return this.c.getStringList("features.autoFarm.cropsBlacklist");
    }

    public boolean requireChunkLoaded() {
        return this.c.getBoolean("safety.requireChunkLoaded", true);
    }
}

