/*
 * Decompiled with CFR 0.152.
 */
package net.ppekkungz.essentialUtils.features.farm;

import java.util.HashSet;
import java.util.Set;
import net.ppekkungz.essentialUtils.config.PluginConfig;
import net.ppekkungz.essentialUtils.features.Feature;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;

public class AutoFarmFeature
implements Feature {
    private final PluginConfig cfg;
    private final Set<Material> allowed;

    public AutoFarmFeature(PluginConfig cfg, Set<Material> allowed) {
        this.cfg = cfg;
        this.allowed = allowed;
    }

    @Override
    public String name() {
        return "Auto-Farm";
    }

    @Override
    public boolean canTrigger(Player p, Block origin) {
        return this.allowed.contains(origin.getType());
    }

    @Override
    public Set<Block> collectTargets(Player p, Block origin) {
        int r = this.cfg.farmRadius();
        HashSet<Block> out = new HashSet<Block>();
        for (int dx = -r; dx <= r; ++dx) {
            for (int dz = -r; dz <= r; ++dz) {
                Block b = origin.getRelative(dx, 0, dz);
                if (!this.allowed.contains(b.getType()) || !this.isMature(b)) continue;
                out.add(b);
            }
        }
        return out;
    }

    private boolean isMature(Block b) {
        BlockData blockData = b.getBlockData();
        if (!(blockData instanceof Ageable)) {
            return false;
        }
        Ageable age = (Ageable)blockData;
        return age.getAge() >= age.getMaximumAge();
    }
}

