/*
 * Decompiled with CFR 0.152.
 */
package net.ppekkungz.essentialUtils.features.tree;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import net.ppekkungz.essentialUtils.config.PluginConfig;
import net.ppekkungz.essentialUtils.features.Feature;
import net.ppekkungz.essentialUtils.util.BlockUtil;
import net.ppekkungz.essentialUtils.util.Materials;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class TreeAssistFeature
implements Feature {
    private final PluginConfig cfg;
    private static final int LEAF_CHECK_RADIUS = 3;

    public TreeAssistFeature(PluginConfig cfg) {
        this.cfg = cfg;
    }

    @Override
    public String name() {
        return "Tree-Assist";
    }

    @Override
    public boolean canTrigger(Player p, Block origin) {
        return Materials.isLog(origin.getType(), this.cfg.treeIncludeStripped());
    }

    @Override
    public Set<Block> collectTargets(Player p, Block origin) {
        Block stump = this.findStump(origin);
        if (this.cfg.treeRequireLeaves() && !this.hasLeavesNearby(origin, 3)) {
            return Collections.emptySet();
        }
        int limit = this.cfg.treeMaxLogs();
        LinkedHashSet<Block> result = new LinkedHashSet<Block>();
        ArrayDeque<Block> dq = new ArrayDeque<Block>();
        dq.add(stump);
        result.add(stump);
        block0: while (!dq.isEmpty() && result.size() < limit) {
            Block b = (Block)dq.poll();
            for (Block n : BlockUtil.neighbors27(b)) {
                if (result.size() >= limit) continue block0;
                if (result.contains(n) || !Materials.isLog(n.getType(), this.cfg.treeIncludeStripped())) continue;
                result.add(n);
                dq.add(n);
            }
        }
        return result;
    }

    private Block findStump(Block start) {
        Block below;
        Block cur = start;
        while (Materials.isLog(cur.getType(), this.cfg.treeIncludeStripped()) && Materials.isLog((below = cur.getRelative(0, -1, 0)).getType(), this.cfg.treeIncludeStripped())) {
            cur = below;
        }
        return cur;
    }

    private boolean hasLeavesNearby(Block origin, int r) {
        for (int dx = -r; dx <= r; ++dx) {
            for (int dy = -r; dy <= r; ++dy) {
                for (int dz = -r; dz <= r; ++dz) {
                    Block b = origin.getRelative(dx, dy, dz);
                    if (!b.getType().name().endsWith("_LEAVES")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Material saplingForLog(Material log) {
        String n = log.name().replace("STRIPPED_", "");
        if (n.endsWith("_LOG")) {
            n = n.substring(0, n.length() - 4);
        }
        return switch (n) {
            case "OAK", "DARK_OAK" -> Material.OAK_SAPLING;
            case "BIRCH" -> Material.BIRCH_SAPLING;
            case "SPRUCE" -> Material.SPRUCE_SAPLING;
            case "JUNGLE" -> Material.JUNGLE_SAPLING;
            case "ACACIA" -> Material.ACACIA_SAPLING;
            case "MANGROVE" -> Material.MANGROVE_PROPAGULE;
            case "CHERRY" -> Material.CHERRY_SAPLING;
            case "PALE_OAK" -> Material.PALE_OAK_SAPLING;
            default -> Material.OAK_SAPLING;
        };
    }
}

