/*
 * Decompiled with CFR 0.152.
 */
package net.ppekkungz.essentialUtils.features.vein;

import java.util.ArrayDeque;
import java.util.LinkedHashSet;
import java.util.Set;
import net.ppekkungz.essentialUtils.config.PluginConfig;
import net.ppekkungz.essentialUtils.features.Feature;
import net.ppekkungz.essentialUtils.util.BlockUtil;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class VeinMineFeature
implements Feature {
    private final PluginConfig cfg;
    private final Set<Material> whitelist;
    private final Set<Material> blacklist;

    public VeinMineFeature(PluginConfig cfg, Set<Material> white, Set<Material> black) {
        this.cfg = cfg;
        this.whitelist = white;
        this.blacklist = black;
    }

    @Override
    public String name() {
        return "Vein-Mine";
    }

    @Override
    public boolean canTrigger(Player p, Block origin) {
        Material m = origin.getType();
        return this.whitelist.contains(m) && !this.blacklist.contains(m);
    }

    @Override
    public Set<Block> collectTargets(Player p, Block origin) {
        int limit = this.cfg.veinMaxOres();
        Material ore = origin.getType();
        LinkedHashSet<Block> result = new LinkedHashSet<Block>();
        ArrayDeque<Block> dq = new ArrayDeque<Block>();
        dq.add(origin);
        result.add(origin);
        block0: while (!dq.isEmpty() && result.size() < limit) {
            Block b = (Block)dq.poll();
            for (Block n : BlockUtil.neighbors6(b)) {
                if (result.size() >= limit) continue block0;
                if (result.contains(n) || n.getType() != ore) continue;
                result.add(n);
                dq.add(n);
            }
        }
        return result;
    }
}

