/*
 * Decompiled with CFR 0.152.
 */
package net.ppekkungz.essentialUtils.indicator;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;

public class BossBarIndicator {
    private final Map<UUID, BossBar> bars = new ConcurrentHashMap<UUID, BossBar>();

    public void showProgress(Player p, String title, double progress) {
        BossBar bar = this.bars.computeIfAbsent(p.getUniqueId(), id -> Bukkit.createBossBar((String)title, (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SEGMENTED_10, (BarFlag[])new BarFlag[0]));
        bar.setVisible(true);
        bar.setTitle(title);
        bar.setProgress(Math.max(0.0, Math.min(1.0, progress)));
        if (!bar.getPlayers().contains(p)) {
            bar.addPlayer(p);
        }
    }

    public void hide(Player p) {
        BossBar bar = this.bars.remove(p.getUniqueId());
        if (bar != null) {
            bar.removeAll();
            bar.setVisible(false);
        }
    }
}

