/*
 * Decompiled with CFR 0.152.
 */
package net.ppekkungz.essentialUtils.listener;

import java.util.Set;
import net.ppekkungz.essentialUtils.EssentialUtils;
import net.ppekkungz.essentialUtils.config.PluginConfig;
import net.ppekkungz.essentialUtils.features.Feature;
import net.ppekkungz.essentialUtils.features.farm.AutoFarmFeature;
import net.ppekkungz.essentialUtils.features.tree.TreeAssistFeature;
import net.ppekkungz.essentialUtils.features.vein.VeinMineFeature;
import net.ppekkungz.essentialUtils.indicator.BossBarIndicator;
import net.ppekkungz.essentialUtils.state.PlayerState;
import net.ppekkungz.essentialUtils.state.StateManager;
import net.ppekkungz.essentialUtils.util.HarvestUtil;
import net.ppekkungz.essentialUtils.util.Materials;
import net.ppekkungz.essentialUtils.util.Ores;
import net.ppekkungz.essentialUtils.work.WorkItem;
import net.ppekkungz.essentialUtils.work.WorkService;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ActivationListener
implements Listener {
    private final EssentialUtils plugin;
    private final PluginConfig cfg;
    private final StateManager states;
    private final WorkService work;
    private final Feature tree;
    private final Feature vein;
    private final Feature farm;
    private final Set<Material> oresWhitelist;
    private final Set<Material> oresBlacklist;
    private final Set<Material> farmAllow;
    private final BossBarIndicator boss = new BossBarIndicator();

    public ActivationListener(EssentialUtils plugin, PluginConfig cfg, StateManager states, WorkService work) {
        this.plugin = plugin;
        this.cfg = cfg;
        this.states = states;
        this.work = work;
        this.oresWhitelist = Ores.expandWhitelist(cfg.veinWhitelist(), cfg.veinIncludeVariants());
        this.oresBlacklist = Materials.fromListPatterns(cfg.veinBlacklist());
        this.farmAllow = Materials.fromListPatterns(cfg.farmWhitelist());
        this.tree = new TreeAssistFeature(cfg);
        this.vein = new VeinMineFeature(cfg, this.oresWhitelist, this.oresBlacklist);
        this.farm = new AutoFarmFeature(cfg, this.farmAllow);
    }

    private boolean isAxe(ItemStack it) {
        return it != null && it.getType().name().endsWith("_AXE");
    }

    private boolean isPick(ItemStack it) {
        return it != null && it.getType().name().endsWith("_PICKAXE");
    }

    private boolean isHoe(ItemStack it) {
        return it != null && it.getType().name().endsWith("_HOE");
    }

    private boolean isSupportedTool(ItemStack it) {
        return this.isAxe(it) || this.isPick(it) || this.isHoe(it);
    }

    private boolean requireToolWhileHold() {
        return this.plugin.getConfig().getBoolean("activation.requireToolWhileHold", true);
    }

    private int holdSneakMillis() {
        int sec = this.plugin.getConfig().getInt("activation.holdSneakSeconds", 5);
        return Math.max(1, sec) * 1000;
    }

    @EventHandler
    public void onSneak(PlayerToggleSneakEvent e) {
        Player p = e.getPlayer();
        if (e.isSneaking()) {
            if (this.requireToolWhileHold() && !this.isSupportedTool(p.getInventory().getItemInMainHand())) {
                return;
            }
            this.states.startHold(p);
            this.states.set(p, PlayerState.ARMED);
            int totalMs = this.holdSneakMillis();
            p.getScheduler().runAtFixedRate((Plugin)this.plugin, task -> {
                if (!p.isSneaking() || this.requireToolWhileHold() && !this.isSupportedTool(p.getInventory().getItemInMainHand())) {
                    this.boss.hide(p);
                    task.cancel();
                    return;
                }
                long held = this.states.heldMillis(p);
                double prog = Math.min(1.0, (double)held / (double)totalMs);
                this.boss.showProgress(p, "\u00a7a[EssentialUtils] Hold Shift to arm\u2026", prog);
                if (held >= (long)totalMs) {
                    this.boss.hide(p);
                    p.sendActionBar("\u00a7a[EssentialUtils] Armed. Use your tool on a block.");
                    task.cancel();
                }
            }, null, 1L, 1L);
        } else {
            this.boss.hide(p);
            this.states.stopHold(p);
            this.states.set(p, PlayerState.IDLE);
            this.work.stopLoop(p);
            p.sendActionBar("\u00a77[EssentialUtils] \u00a7cDeactivated (stopped sneaking)");
        }
    }

    @EventHandler
    public void onSlot(PlayerItemHeldEvent e) {
        Player p = e.getPlayer();
        this.boss.hide(p);
        this.states.reset(p);
        this.work.stopLoop(p);
        p.sendActionBar("\u00a77[EssentialUtils] \u00a7cDeactivated (item changed)");
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        if (e.getAction() != Action.LEFT_CLICK_BLOCK && e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block b = e.getClickedBlock();
        if (b == null) {
            return;
        }
        Player p = e.getPlayer();
        if (!p.isSneaking()) {
            return;
        }
        if (this.states.heldMillis(p) < (long)this.holdSneakMillis()) {
            return;
        }
        ItemStack hand = p.getInventory().getItemInMainHand();
        if (!this.isSupportedTool(hand)) {
            return;
        }
        Feature f = null;
        if (this.cfg.treeEnabled() && this.isAxe(hand) && this.tree.canTrigger(p, b)) {
            f = this.tree;
        } else if (this.cfg.veinEnabled() && this.isPick(hand) && this.vein.canTrigger(p, b)) {
            f = this.vein;
        } else if (this.cfg.farmEnabled() && this.isHoe(hand) && this.farm.canTrigger(p, b)) {
            f = this.farm;
        }
        if (f == null) {
            return;
        }
        Set<Block> targets = f.collectTargets(p, b);
        if (targets.isEmpty()) {
            p.sendActionBar("\u00a77[EssentialUtils] No targets.");
            return;
        }
        int idx = 0;
        for (Block tb : targets) {
            int cd = 0;
            WorkItem.FeatureTag tag = WorkItem.FeatureTag.OTHER;
            if (f == this.tree) {
                tag = WorkItem.FeatureTag.TREE;
                int per = this.plugin.getConfig().getInt("features.treeAssist.breakDelayTicks", 2);
                cd = Math.max(0, per) * idx;
            } else if (f == this.vein) {
                tag = WorkItem.FeatureTag.VEIN;
                int tier = HarvestUtil.pickaxeTier(p.getInventory().getItemInMainHand());
                targets.removeIf(block -> tier < HarvestUtil.requiredTierForOre(block.getType()));
                if (targets.isEmpty()) {
                    p.sendActionBar("\u00a7c[EssentialUtils] Your pickaxe tier is too low for this vein.");
                    return;
                }
                int base = this.plugin.getConfig().getInt("features.veinMine.breakDelayBaseTicks", 1);
                int extra = this.plugin.getConfig().getInt("features.veinMine.breakDelayExtraPer16", 1) * (targets.size() / 16);
                cd = Math.max(0, base + extra) * idx;
            } else if (f == this.farm) {
                tag = WorkItem.FeatureTag.FARM;
                cd = 0;
            }
            this.work.queue(p).add(new WorkItem(p, tb, WorkItem.Action.BREAK, null, 0, cd, tag));
            ++idx;
        }
        if (f == this.tree && this.cfg.treeReplantEnabled()) {
            Material sapling = TreeAssistFeature.saplingForLog(b.getType());
            Block stump = this.findStumpFromSet(targets);
            if (stump != null) {
                Block plantPos = stump.getRelative(0, 1, 0);
                p.getScheduler().runDelayed((Plugin)this.plugin, task -> {
                    WorkItem item = new WorkItem(p, plantPos, WorkItem.Action.PLANT, sapling, Math.max(0, this.cfg.treeReplantMaxRetries()), 0, WorkItem.FeatureTag.TREE);
                    this.work.queue(p).add(item);
                }, null, 20L);
            }
        }
        this.states.set(p, PlayerState.ACTIVE);
        this.work.ensureLoop(p);
        p.sendActionBar("\u00a7a[EssentialUtils] \u00a7f" + f.name() + " queued \u00a7e" + targets.size() + " \u00a77blocks.");
        e.setCancelled(true);
    }

    private Block findStumpFromSet(Set<Block> logs) {
        Block best = null;
        int bestY = Integer.MAX_VALUE;
        for (Block b : logs) {
            if (b.getY() >= bestY) continue;
            bestY = b.getY();
            best = b;
        }
        return best;
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        this.boss.hide(e.getPlayer());
        this.work.stopLoop(e.getPlayer());
        this.states.reset(e.getPlayer());
    }
}

