/*
 * Decompiled with CFR 0.152.
 */
package net.ppekkungz.essentialUtils.state;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.ppekkungz.essentialUtils.state.PlayerState;
import org.bukkit.entity.Player;

public class StateManager {
    private final Map<UUID, PlayerState> states = new ConcurrentHashMap<UUID, PlayerState>();
    private final Map<UUID, Long> sneakStart = new ConcurrentHashMap<UUID, Long>();

    public PlayerState get(Player p) {
        return this.states.getOrDefault(p.getUniqueId(), PlayerState.IDLE);
    }

    public void set(Player p, PlayerState s) {
        this.states.put(p.getUniqueId(), s);
    }

    public void startHold(Player p) {
        this.sneakStart.put(p.getUniqueId(), System.currentTimeMillis());
    }

    public void stopHold(Player p) {
        this.sneakStart.remove(p.getUniqueId());
    }

    public long heldMillis(Player p) {
        Long t = this.sneakStart.get(p.getUniqueId());
        return t == null ? 0L : System.currentTimeMillis() - t;
    }

    public void reset(Player p) {
        UUID id = p.getUniqueId();
        this.states.remove(id);
        this.sneakStart.remove(id);
    }
}

