/*
 * Decompiled with CFR 0.152.
 */
package net.ppekkungz.essentialUtils.work;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.ppekkungz.essentialUtils.EssentialUtils;
import net.ppekkungz.essentialUtils.config.PluginConfig;
import net.ppekkungz.essentialUtils.indicator.ActionBarIndicator;
import net.ppekkungz.essentialUtils.indicator.IndicatorService;
import net.ppekkungz.essentialUtils.state.PlayerState;
import net.ppekkungz.essentialUtils.state.StateManager;
import net.ppekkungz.essentialUtils.util.HarvestUtil;
import net.ppekkungz.essentialUtils.util.Protection;
import net.ppekkungz.essentialUtils.work.WorkItem;
import net.ppekkungz.essentialUtils.work.WorkQueue;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class WorkService {
    private final EssentialUtils plugin;
    private final PluginConfig cfg;
    private final StateManager states;
    private final IndicatorService indicator = new ActionBarIndicator();
    private final Map<UUID, WorkQueue> queues = new ConcurrentHashMap<UUID, WorkQueue>();
    private final Map<UUID, ScheduledTask> loops = new ConcurrentHashMap<UUID, ScheduledTask>();
    private final Map<UUID, Integer> treeBroken = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Integer> veinBroken = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Long> lastTierWarn = new ConcurrentHashMap<UUID, Long>();

    public WorkService(EssentialUtils plugin, PluginConfig cfg, StateManager states) {
        this.plugin = plugin;
        this.cfg = cfg;
        this.states = states;
    }

    public WorkQueue queue(Player p) {
        return this.queues.computeIfAbsent(p.getUniqueId(), k -> new WorkQueue());
    }

    public void ensureLoop(Player p) {
        this.loops.computeIfAbsent(p.getUniqueId(), id -> p.getScheduler().runAtFixedRate((Plugin)this.plugin, task -> this.tickPlayer(p), null, 1L, 1L));
    }

    public void stopLoop(Player p) {
        ScheduledTask t = this.loops.remove(p.getUniqueId());
        if (t != null) {
            t.cancel();
        }
        this.queues.remove(p.getUniqueId());
        this.treeBroken.remove(p.getUniqueId());
        this.veinBroken.remove(p.getUniqueId());
        this.lastTierWarn.remove(p.getUniqueId());
    }

    public void shutdown() {
        this.loops.values().forEach(ScheduledTask::cancel);
        this.loops.clear();
        this.queues.clear();
        this.treeBroken.clear();
        this.veinBroken.clear();
        this.lastTierWarn.clear();
    }

    private int capFor(WorkItem.FeatureTag tag) {
        return switch (tag) {
            case WorkItem.FeatureTag.TREE -> this.cfg.treeMaxPerTick();
            case WorkItem.FeatureTag.VEIN -> this.cfg.veinMaxPerTick();
            case WorkItem.FeatureTag.FARM -> this.cfg.farmMaxPerTick();
            default -> Integer.MAX_VALUE;
        };
    }

    private void tickPlayer(Player p) {
        WorkItem wi;
        if (!p.isOnline()) {
            this.stopLoop(p);
            return;
        }
        WorkQueue q = this.queue(p);
        if (q.isEmpty()) {
            if (this.states.get(p) == PlayerState.ACTIVE) {
                this.indicator.show(p, "\u00a77[EssentialUtils] \u00a7fQueue empty. \u00a7cIdle");
                this.states.set(p, PlayerState.IDLE);
            }
            return;
        }
        int perPlayerBudget = this.cfg.perPlayerBudget();
        EnumMap<WorkItem.FeatureTag, Integer> used = new EnumMap<WorkItem.FeatureTag, Integer>(WorkItem.FeatureTag.class);
        for (WorkItem.FeatureTag t : WorkItem.FeatureTag.values()) {
            used.put(t, 0);
        }
        int processed = 0;
        int guard = Math.max(64, q.size() * 2);
        for (int i = 0; i < guard && processed < perPlayerBudget && (wi = q.poll()) != null; ++i) {
            if (wi.cooldownTicks > 0) {
                --wi.cooldownTicks;
                q.add(wi);
                continue;
            }
            int usedSoFar = used.getOrDefault((Object)wi.tag, 0);
            if (usedSoFar >= this.capFor(wi.tag)) {
                q.add(wi);
                continue;
            }
            Block b = wi.block;
            if (this.cfg.requireChunkLoaded() && !b.getChunk().isLoaded()) {
                wi.cooldownTicks = Math.max(1, this.cfg.treeReplantRetryCooldownTicks());
                q.add(wi);
                continue;
            }
            if (!Protection.canModify(wi.player, b)) continue;
            switch (wi.action) {
                case BREAK: {
                    if (b.getType().isAir()) break;
                    this.breakControlled(wi);
                    break;
                }
                case PLANT: {
                    if (!this.cfg.treeReplantEnabled()) break;
                    this.handlePlant(wi, q);
                }
            }
            used.put(wi.tag, usedSoFar + 1);
            ++processed;
        }
        if (this.cfg.showProgress()) {
            this.indicator.show(p, "\u00a7a[EU] \u00a7fTick: \u00a7e" + processed + "\u00a77/\u00a7b" + perPlayerBudget + " \u00a77| Q: \u00a7b" + q.size());
        }
    }

    private void breakControlled(WorkItem wi) {
        Player p = wi.player;
        Block b = wi.block;
        if (wi.tag == WorkItem.FeatureTag.TREE || wi.tag == WorkItem.FeatureTag.FARM) {
            b.breakNaturally(p.getInventory().getItemInMainHand(), true);
            if (wi.tag == WorkItem.FeatureTag.TREE) {
                this.damageToolEveryN(p, wi.tag);
            }
            return;
        }
        if (wi.tag == WorkItem.FeatureTag.VEIN) {
            long last;
            long now;
            int need;
            int tier = HarvestUtil.pickaxeTier(p.getInventory().getItemInMainHand());
            if (tier >= (need = HarvestUtil.requiredTierForOre(b.getType()))) {
                b.breakNaturally(p.getInventory().getItemInMainHand(), true);
                this.damageToolEveryN(p, wi.tag);
                return;
            }
            if (this.plugin.getConfig().getBoolean("features.veinMine.alertOnInsufficientTier", true) && (now = System.currentTimeMillis()) - (last = this.lastTierWarn.getOrDefault(p.getUniqueId(), 0L).longValue()) >= 1000L) {
                p.sendActionBar("\u00a7c[EssentialUtils] Can't mine " + String.valueOf(b.getType()) + " with your pickaxe. Requires \u00a7e" + HarvestUtil.tierName(need) + "\u00a7c.");
                this.lastTierWarn.put(p.getUniqueId(), now);
            }
        }
    }

    private void damageToolEveryN(Player p, WorkItem.FeatureTag tag) {
        int step;
        switch (tag) {
            case TREE: {
                int n = this.plugin.getConfig().getInt("features.treeAssist.durabilityPerNBlocks", 8);
                break;
            }
            case VEIN: {
                int n = this.plugin.getConfig().getInt("features.veinMine.durabilityPerNBlocks", 10);
                break;
            }
            default: {
                int n = step = 0;
            }
        }
        if (step <= 0) {
            return;
        }
        Map<UUID, Integer> map = tag == WorkItem.FeatureTag.TREE ? this.treeBroken : this.veinBroken;
        int count = map.getOrDefault(p.getUniqueId(), 0) + 1;
        if (count >= step) {
            ItemMeta itemMeta;
            map.put(p.getUniqueId(), 0);
            ItemStack hand = p.getInventory().getItemInMainHand();
            if (hand != null && (itemMeta = hand.getItemMeta()) instanceof Damageable) {
                Damageable dmg = (Damageable)itemMeta;
                dmg.setDamage(dmg.getDamage() + 1);
                hand.setItemMeta((ItemMeta)dmg);
            }
        } else {
            map.put(p.getUniqueId(), count);
        }
    }

    private void handlePlant(WorkItem wi, WorkQueue q) {
        Block airPos = wi.block;
        if (airPos.getType().isAir()) {
            Block soil = airPos.getRelative(0, -1, 0);
            if (this.cfg.treeAllowedSoils().contains(soil.getType()) && this.consumeIfRequired(wi.player, wi.plantType)) {
                airPos.setType(wi.plantType, true);
                return;
            }
        }
        if (wi.retries > 0) {
            --wi.retries;
            wi.cooldownTicks = Math.max(1, this.cfg.treeReplantRetryCooldownTicks());
            q.add(wi);
        }
    }

    private boolean consumeIfRequired(Player p, Material sapling) {
        if (!this.cfg.treeReplantEnabled()) {
            return false;
        }
        if (!this.cfg.treeReplantRequireInventory()) {
            return true;
        }
        for (ItemStack stack : p.getInventory().getContents()) {
            if (stack == null || stack.getType() != sapling || stack.getAmount() <= 0) continue;
            stack.setAmount(stack.getAmount() - 1);
            return true;
        }
        return false;
    }
}

