/*
 * Decompiled with CFR 0.152.
 */
package me.basiqueevangelist.spiritwalker.client;

import com.mojang.blaze3d.vertex.PoseStack;
import me.basiqueevangelist.spiritwalker.client.FakeCameraEntity;
import me.basiqueevangelist.spiritwalker.mixin.client.LevelRendererAccessor;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.KeyboardInput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class SpiritWalkerClient {
    public static boolean STOPPING_SPIRIT_WALK = false;

    @ApiStatus.Internal
    public static void enterSpiritWalk(LivingEntity entity, int level) {
        if (!(entity instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer player = (LocalPlayer)entity;
        STOPPING_SPIRIT_WALK = false;
        Minecraft client = Minecraft.getInstance();
        Entity entity2 = client.cameraEntity;
        if (!(entity2 instanceof FakeCameraEntity)) {
            FakeCameraEntity camera = new FakeCameraEntity(client, client.level);
            camera.absMoveTo(player.getX(), player.getY(), player.getZ(), player.getYHeadRot(), player.getXRot());
            camera.input = new KeyboardInput(client.options);
            client.player.input = new Input();
            client.setCameraEntity((Entity)camera);
            camera.canNoClip = level > 0;
        } else {
            FakeCameraEntity camera = (FakeCameraEntity)entity2;
            camera.canNoClip = level > 0;
        }
    }

    public static void leaveSpiritWalk(LivingEntity entity) {
        if (!(entity instanceof LocalPlayer)) {
            return;
        }
        if (!(Minecraft.getInstance().cameraEntity instanceof FakeCameraEntity)) {
            return;
        }
        STOPPING_SPIRIT_WALK = true;
    }

    public static boolean isInSpiritWalk(Player player) {
        return player instanceof LocalPlayer && Minecraft.getInstance().cameraEntity instanceof FakeCameraEntity;
    }

    public static void endClientTick(Minecraft client) {
        if (client.isPaused()) {
            return;
        }
        Entity entity = client.cameraEntity;
        if (!(entity instanceof FakeCameraEntity)) {
            return;
        }
        FakeCameraEntity camera = (FakeCameraEntity)entity;
        double prevX = camera.getX();
        double prevY = camera.getY();
        double prevZ = camera.getZ();
        if (STOPPING_SPIRIT_WALK) {
            camera.absMoveTo((camera.getX() * 4.0 + client.player.getX()) / 5.0, (camera.getY() * 4.0 + client.player.getY()) / 5.0, (camera.getZ() * 4.0 + client.player.getZ()) / 5.0);
        } else {
            camera.tick();
        }
        camera.xo = prevX;
        camera.yo = prevY;
        camera.zo = prevZ;
        if (STOPPING_SPIRIT_WALK && camera.distanceToSqr((Entity)client.player) < 0.1) {
            client.setCameraEntity((Entity)client.player);
            client.player.input = new KeyboardInput(client.options);
            STOPPING_SPIRIT_WALK = false;
        }
    }

    public static void renderAfterEntities(Camera camera, PoseStack matrixStack, LevelRenderer levelRenderer, MultiBufferSource bufSource) {
        Entity entity = camera.getEntity();
        if (entity instanceof FakeCameraEntity) {
            FakeCameraEntity camEntity = (FakeCameraEntity)entity;
            if (camera.isDetached()) {
                matrixStack.pushPose();
                camEntity.xOld = camEntity.xo;
                camEntity.yOld = camEntity.yo;
                camEntity.zOld = camEntity.zo;
                ((LevelRendererAccessor)levelRenderer).callRenderEntity((Entity)camEntity, camera.getPosition().x, camera.getPosition().y, camera.getPosition().z, Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false), matrixStack, bufSource);
                matrixStack.popPose();
            }
        }
    }
}

