/*
 * Decompiled with CFR 0.152.
 */
package me.basiqueevangelist.spiritwalker.neoforge;

import me.basiqueevangelist.spiritwalker.SpiritWalker;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@Mod(value="spirit_walker")
@EventBusSubscriber(modid="spirit_walker", bus=EventBusSubscriber.Bus.GAME)
public class SpiritWalkerNeoforge {
    public static final String MOD_ID = "spirit_walker";

    public SpiritWalkerNeoforge() {
        SpiritWalker.init();
    }

    @SubscribeEvent
    public static void afterDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (!player.hasEffect((Holder)SpiritWalker.EFFECT.get())) {
            return;
        }
        SpiritWalker.DIED_DURING_SPIRIT_WALK.trigger(player);
    }

    @SubscribeEvent
    public static void useEntity(PlayerInteractEvent.EntityInteract event) {
        if (SpiritWalker.isInSpiritWalk(event.getEntity())) {
            event.setCancellationResult(InteractionResult.FAIL);
        }
    }

    @SubscribeEvent
    public static void useBlock(PlayerInteractEvent.RightClickBlock event) {
        if (SpiritWalker.isInSpiritWalk(event.getEntity())) {
            event.setCancellationResult(InteractionResult.FAIL);
        }
    }

    @SubscribeEvent
    public static void useItem(PlayerInteractEvent.RightClickItem event) {
        if (SpiritWalker.isInSpiritWalk(event.getEntity())) {
            event.setCancellationResult(InteractionResult.FAIL);
        }
    }

    @SubscribeEvent
    public static void addRecipes(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
        builder.addMix(Potions.AWKWARD, Items.WARPED_FUNGUS, (Holder)SpiritWalker.POTION.get());
        builder.addMix((Holder)SpiritWalker.POTION.get(), Items.REDSTONE, (Holder)SpiritWalker.LONG_POTION.get());
        builder.addMix((Holder)SpiritWalker.POTION.get(), Items.GLOWSTONE_DUST, (Holder)SpiritWalker.STRONG_POTION.get());
    }
}

