/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block;

import com.mrbysco.enchantableblocks.block.blockentity.EnchantedCampfireBlockEntity;
import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import com.mrbysco.enchantableblocks.util.EnchantmentUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;

public class EnchantedCampfireBlock
extends CampfireBlock {
    private final Supplier<Block> originalBlock;

    public EnchantedCampfireBlock(boolean spawnParticles, int fireDamage, Supplier<Block> originalBlock, BlockBehaviour.Properties properties) {
        super(spawnParticles, fireDamage, properties);
        this.originalBlock = originalBlock;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new EnchantedCampfireBlockEntity(pos, state);
    }

    public Item asItem() {
        return this.originalBlock.get().asItem();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide) {
            return (Boolean)state.getValue((Property)LIT) != false ? EnchantedCampfireBlock.createTickerHelper(blockEntityType, ModRegistry.ENCHANTED_CAMPFIRE_BLOCK_ENTITY.get(), EnchantedCampfireBlockEntity::particleTick) : null;
        }
        return (Boolean)state.getValue((Property)LIT) != false ? EnchantedCampfireBlock.createTickerHelper(blockEntityType, ModRegistry.ENCHANTED_CAMPFIRE_BLOCK_ENTITY.get(), EnchantedCampfireBlockEntity::cookTick) : EnchantedCampfireBlock.createTickerHelper(blockEntityType, ModRegistry.ENCHANTED_CAMPFIRE_BLOCK_ENTITY.get(), EnchantedCampfireBlockEntity::cooldownTick);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && entity instanceof LivingEntity) {
            Holder<Enchantment> boilingHolder;
            IEnchantable enchantable;
            float damage = this.fireDamage;
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(boilingHolder = EnchantmentUtil.getEnchantmentHolder(blockentity, ModEnchantments.BOILING))) {
                int enchantmentLevel = enchantable.getEnchantmentLevel(boilingHolder);
                damage *= (float)(enchantmentLevel + 1);
            }
            entity.hurt(level.damageSources().inFire(), damage);
        }
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        Holder<Enchantment> blastHolder;
        IEnchantable enchantable;
        float explosionResistance = super.getExplosionResistance(state, level, pos, explosion);
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(blastHolder = EnchantmentUtil.getEnchantmentHolder(blockentity, (ResourceKey<Enchantment>)Enchantments.BLAST_PROTECTION))) {
            int enchantmentLevel = enchantable.getEnchantmentLevel(blastHolder);
            explosionResistance *= (float)((enchantmentLevel + 1) * 30);
        }
        return explosionResistance;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            EnchantedCampfireBlockEntity campfireBlockEntity;
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (blockentity instanceof EnchantedCampfireBlockEntity && !(campfireBlockEntity = (EnchantedCampfireBlockEntity)blockentity).hasEnchantment(EnchantmentUtil.getEnchantmentHolder(blockentity, (ResourceKey<Enchantment>)Enchantments.VANISHING_CURSE))) {
                Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)campfireBlockEntity.getItems());
            }
            if (!(!state.hasBlockEntity() || state.is(newState.getBlock()) && newState.hasBlockEntity())) {
                level.removeBlockEntity(pos);
            }
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        IEnchantable enchantable;
        BlockEntity blockentity = (BlockEntity)params.getParameter(LootContextParams.BLOCK_ENTITY);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(EnchantmentUtil.getEnchantmentHolder(blockentity, (ResourceKey<Enchantment>)Enchantments.VANISHING_CURSE))) {
            return List.of();
        }
        return super.getDrops(state, params);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource prandom) {
        IEnchantable enchantable;
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof IEnchantable && !(enchantable = (IEnchantable)blockentity).hasEnchantment(EnchantmentUtil.getEnchantmentHolder(blockentity, ModEnchantments.CONCEALED))) {
            super.animateTick(state, level, pos, prandom);
        }
    }
}

