/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block.blockentity;

import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.util.TagHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractEnchantedBlockEntity
extends BlockEntity
implements IEnchantable {
    protected boolean hideGlint = false;
    protected ItemEnchantments enchantments = ItemEnchantments.EMPTY;

    public AbstractEnchantedBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    @Override
    public ItemEnchantments getEnchantments() {
        return this.enchantments;
    }

    @Override
    public boolean hasEnchantment(Holder<Enchantment> enchantment) {
        return this.enchantments.getLevel(enchantment) > 0;
    }

    @Override
    public int getEnchantmentLevel(Holder<Enchantment> enchantment) {
        if (this.hasEnchantment(enchantment)) {
            return this.enchantments.getLevel(enchantment);
        }
        return -1;
    }

    @Override
    public boolean hasEnchantment(TagKey<Enchantment> enchantmentTag) {
        for (Holder enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(this.level.registryAccess(), (Holder<Enchantment>)enchantment, enchantmentTag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getEnchantmentLevel(TagKey<Enchantment> enchantmentTag) {
        for (Holder enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(this.level.registryAccess(), (Holder<Enchantment>)enchantment, enchantmentTag)) continue;
            return this.enchantments.getLevel(enchantment);
        }
        return -1;
    }

    @Override
    public void setEnchantments(ItemEnchantments enchantments) {
        this.enchantments = enchantments;
    }

    @Override
    public boolean hideGlint() {
        return this.hideGlint;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.loadEnchantments(tag, registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveEnchantments(tag, registries);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        ItemEnchantments enchantments = (ItemEnchantments)componentInput.get(DataComponents.ENCHANTMENTS);
        if (enchantments != null) {
            this.enchantments = enchantments;
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(DataComponents.ENCHANTMENTS, (Object)this.getEnchantments());
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        CompoundTag tag = packet.getTag();
        if (tag != null) {
            this.handleUpdateTag(tag, registries);
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }

    public CompoundTag getPersistentData() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
        return tag;
    }
}

