/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block.blockentity;

import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.mixin.HopperBlockEntityAccessor;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import com.mrbysco.enchantableblocks.util.EnchantmentUtil;
import com.mrbysco.enchantableblocks.util.TagHelper;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

public class EnchantedHopperBlockEntity
extends HopperBlockEntity
implements IEnchantable {
    protected boolean hideGlint = false;
    protected ListTag enchantmentTag = null;
    protected ItemEnchantments enchantments = ItemEnchantments.EMPTY;

    public EnchantedHopperBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public BlockEntityType<?> getType() {
        return ModRegistry.ENCHANTED_HOPPER_BLOCK_ENTITY.get();
    }

    public static void pushItemsTick(Level level, BlockPos pos, BlockState state, EnchantedHopperBlockEntity blockEntity) {
        int speed = 1;
        Holder<Enchantment> speedHolder = EnchantmentUtil.getEnchantmentHolder(level, ModEnchantments.SPEED);
        if (blockEntity.hasEnchantment(speedHolder)) {
            speed = blockEntity.getEnchantmentLevel(speedHolder) + 1;
        }
        blockEntity.cooldownTime -= speed;
        blockEntity.tickedGameTime = level.getGameTime();
        if (!((HopperBlockEntityAccessor)((Object)blockEntity)).invokeIsOnCooldown()) {
            int count = 1;
            Holder<Enchantment> efficiencyHolder = EnchantmentUtil.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY);
            if (blockEntity.hasEnchantment(efficiencyHolder)) {
                int enchantmentLevel = Mth.clamp((int)blockEntity.getEnchantmentLevel(efficiencyHolder), (int)0, (int)5);
                count = switch (enchantmentLevel) {
                    case 1 -> 4;
                    case 2 -> 8;
                    case 3 -> 16;
                    case 4 -> 32;
                    case 5 -> 64;
                    default -> count;
                };
            }
            blockEntity.setCooldown(0);
            int finalCount = count;
            EnchantedHopperBlockEntity.tryMoveItems(level, pos, state, blockEntity, () -> EnchantedHopperBlockEntity.suckInItems(level, blockEntity, finalCount));
        }
    }

    public static boolean suckInItems(Level level, EnchantedHopperBlockEntity hopper, int count) {
        Container container = EnchantedHopperBlockEntity.getSourceContainer(level, hopper);
        BlockEntity blockEntity = level.getBlockEntity(hopper.getBlockPos().relative(Direction.UP));
        if (blockEntity != null) {
            IItemHandler itemHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, hopper.getBlockPos().relative(Direction.UP), (Object)Direction.DOWN);
            if (itemHandler != null) {
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack slotStack = itemHandler.getStackInSlot(i);
                    int actualCount = Math.clamp((int)count, (int)1, (int)slotStack.getCount());
                    ItemStack extractItem = itemHandler.extractItem(i, actualCount, true);
                    if (extractItem.isEmpty()) continue;
                    for (int j = 0; j < hopper.getContainerSize(); ++j) {
                        ItemStack destStack = hopper.getItem(j);
                        if (!hopper.canPlaceItem(j, extractItem) || !destStack.isEmpty() && (destStack.getCount() >= destStack.getMaxStackSize() || destStack.getCount() >= hopper.getMaxStackSize() || !ItemStack.isSameItemSameComponents((ItemStack)extractItem, (ItemStack)destStack))) continue;
                        actualCount = Math.min((int)slotStack.getCount(), (int)Math.min((int)count, (int)(destStack.getMaxStackSize() - destStack.getCount())));
                        extractItem = itemHandler.extractItem(i, actualCount, false);
                        if (destStack.isEmpty()) {
                            hopper.setItem(j, extractItem);
                        } else {
                            destStack.grow(actualCount);
                            hopper.setItem(j, destStack);
                        }
                        hopper.setChanged();
                        return true;
                    }
                }
                return false;
            }
            for (ItemEntity itementity : EnchantedHopperBlockEntity.getItemsAtAndAbove((Level)level, (Hopper)hopper)) {
                if (!EnchantedHopperBlockEntity.addItem((Container)hopper, (ItemEntity)itementity)) continue;
                return true;
            }
        } else {
            if (container != null) {
                Direction direction = Direction.DOWN;
                return EnchantedHopperBlockEntity.isEmptyContainer(container, direction) ? false : EnchantedHopperBlockEntity.getSlots(container, direction).anyMatch(p_59363_ -> EnchantedHopperBlockEntity.tryTakeInItemFromSlot(hopper, container, p_59363_, direction, count));
            }
            for (ItemEntity itementity : EnchantedHopperBlockEntity.getItemsAtAndAbove((Level)level, (Hopper)hopper)) {
                if (!EnchantedHopperBlockEntity.addItem((Container)hopper, (ItemEntity)itementity)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static Container getSourceContainer(Level pLevel, EnchantedHopperBlockEntity pHopper) {
        return EnchantedHopperBlockEntity.getContainerAt(pLevel, pHopper.getLevelX(), pHopper.getLevelY() + 1.0, pHopper.getLevelZ());
    }

    private static Container getContainerAt(Level pLevel, double pX, double pY, double pZ) {
        List list;
        BlockEntity blockentity;
        WorldlyContainer container = null;
        BlockPos blockpos = BlockPos.containing((double)pX, (double)pY, (double)pZ);
        BlockState blockstate = pLevel.getBlockState(blockpos);
        Block block = blockstate.getBlock();
        if (block instanceof WorldlyContainerHolder) {
            container = ((WorldlyContainerHolder)block).getContainer(blockstate, (LevelAccessor)pLevel, blockpos);
        } else if (blockstate.hasBlockEntity() && (blockentity = pLevel.getBlockEntity(blockpos)) instanceof Container && (container = (Container)blockentity) instanceof ChestBlockEntity && block instanceof ChestBlock) {
            container = ChestBlock.getContainer((ChestBlock)((ChestBlock)block), (BlockState)blockstate, (Level)pLevel, (BlockPos)blockpos, (boolean)true);
        }
        if (container == null && !(list = pLevel.getEntities((Entity)null, new AABB(pX - 0.5, pY - 0.5, pZ - 0.5, pX + 0.5, pY + 0.5, pZ + 0.5), EntitySelector.CONTAINER_ENTITY_SELECTOR)).isEmpty()) {
            container = (Container)list.get(pLevel.random.nextInt(list.size()));
        }
        return container;
    }

    private static boolean isEmptyContainer(Container pContainer, Direction pDirection) {
        return EnchantedHopperBlockEntity.getSlots(pContainer, pDirection).allMatch(slot -> pContainer.getItem(slot).isEmpty());
    }

    private static boolean tryTakeInItemFromSlot(EnchantedHopperBlockEntity pHopper, Container pContainer, int slot, Direction pDirection, int count) {
        ItemStack itemstack = pContainer.getItem(slot);
        if (!itemstack.isEmpty() && EnchantedHopperBlockEntity.canTakeItemFromContainer((Container)pHopper, pContainer, itemstack, slot, pDirection)) {
            ItemStack itemstack1 = itemstack.copy();
            ItemStack itemstack2 = EnchantedHopperBlockEntity.addItem((Container)pContainer, (Container)pHopper, (ItemStack)pContainer.removeItem(slot, Math.min((int)count, (int)itemstack1.getCount())), (Direction)null);
            if (itemstack2.isEmpty()) {
                pContainer.setChanged();
                return true;
            }
            pContainer.setItem(slot, itemstack1);
        }
        return false;
    }

    private static boolean canTakeItemFromContainer(Container pSource, Container pDestination, ItemStack pStack, int pSlot, Direction pDirection) {
        WorldlyContainer worldlycontainer;
        if (!pDestination.canTakeItem(pSource, pSlot, pStack)) {
            return false;
        }
        return !(pDestination instanceof WorldlyContainer) || (worldlycontainer = (WorldlyContainer)pDestination).canTakeItemThroughFace(pSlot, pStack, pDirection);
    }

    private static boolean tryMoveItems(Level level, BlockPos pos, BlockState state, EnchantedHopperBlockEntity blockEntity, BooleanSupplier validator) {
        if (!level.isClientSide && !((HopperBlockEntityAccessor)((Object)blockEntity)).invokeIsOnCooldown() && ((Boolean)state.getValue((Property)HopperBlock.ENABLED)).booleanValue()) {
            boolean flag = false;
            if (!blockEntity.isEmpty()) {
                flag = EnchantedHopperBlockEntity.ejectItems(level, pos, state, blockEntity);
            }
            if (!((HopperBlockEntityAccessor)((Object)blockEntity)).invokeInventoryFull()) {
                flag |= validator.getAsBoolean();
            }
            if (flag) {
                blockEntity.setCooldown(8);
                EnchantedHopperBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
                return true;
            }
        }
        return false;
    }

    private static boolean ejectItems(Level level, BlockPos pos, BlockState state, EnchantedHopperBlockEntity sourceContainer) {
        int count = 1;
        Holder<Enchantment> efficiencyHolder = EnchantmentUtil.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY);
        if (sourceContainer.hasEnchantment(efficiencyHolder)) {
            int enchantmentLevel = Mth.clamp((int)sourceContainer.getEnchantmentLevel(efficiencyHolder), (int)0, (int)5);
            count = switch (enchantmentLevel) {
                case 1 -> 4;
                case 2 -> 8;
                case 3 -> 16;
                case 4 -> 32;
                case 5 -> 64;
                default -> count;
            };
        }
        Direction direction = (Direction)state.getValue((Property)HopperBlock.FACING);
        BlockEntity blockEntity = level.getBlockEntity(pos.relative(direction));
        IItemHandler itemHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos.relative(direction), (Object)direction.getOpposite());
        if (blockEntity != null && itemHandler != null) {
            if (!EnchantedHopperBlockEntity.isFull(itemHandler)) {
                for (int i = 0; i < sourceContainer.getContainerSize(); ++i) {
                    if (sourceContainer.getItem(i).isEmpty()) continue;
                    ItemStack originalSlotContents = sourceContainer.getItem(i).copy();
                    ItemStack insertStack = sourceContainer.removeItem(i, Math.min((int)count, (int)originalSlotContents.getCount()));
                    ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)insertStack, (boolean)false);
                    if (remainder.isEmpty()) {
                        return true;
                    }
                    int extractedAmount = insertStack.getCount() - remainder.getCount();
                    originalSlotContents.shrink(extractedAmount);
                    sourceContainer.setItem(i, originalSlotContents);
                }
            }
            return false;
        }
        Container container = EnchantedHopperBlockEntity.getAttachedContainer(level, pos, state);
        if (container != null && !EnchantedHopperBlockEntity.isFullContainer(container, direction)) {
            for (int i = 0; i < sourceContainer.getContainerSize(); ++i) {
                if (sourceContainer.getItem(i).isEmpty()) continue;
                ItemStack stackCopy = sourceContainer.getItem(i).copy();
                ItemStack addStack = EnchantedHopperBlockEntity.addItem((Container)sourceContainer, (Container)container, (ItemStack)sourceContainer.removeItem(i, Math.min((int)count, (int)stackCopy.getCount())), (Direction)direction);
                if (addStack.isEmpty()) {
                    container.setChanged();
                    return true;
                }
                sourceContainer.setItem(i, stackCopy);
            }
        }
        return false;
    }

    private static boolean isFull(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (!stackInSlot.isEmpty() && stackInSlot.getCount() >= itemHandler.getSlotLimit(slot)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static Container getAttachedContainer(Level pLevel, BlockPos pPos, BlockState pState) {
        Direction direction = (Direction)pState.getValue((Property)HopperBlock.FACING);
        return EnchantedHopperBlockEntity.getContainerAt((Level)pLevel, (BlockPos)pPos.relative(direction));
    }

    private static boolean isFullContainer(Container container, Direction direction) {
        return EnchantedHopperBlockEntity.getSlots(container, direction).allMatch(p_59379_ -> {
            ItemStack itemstack = container.getItem(p_59379_);
            return itemstack.getCount() >= itemstack.getMaxStackSize();
        });
    }

    private static IntStream getSlots(Container pContainer, Direction pDirection) {
        return pContainer instanceof WorldlyContainer ? IntStream.of(((WorldlyContainer)pContainer).getSlotsForFace(pDirection)) : IntStream.range(0, pContainer.getContainerSize());
    }

    private static IntStream getSlots(IItemHandler itemHandler) {
        return IntStream.range(0, itemHandler.getSlots());
    }

    @Override
    public ItemEnchantments getEnchantments() {
        return this.enchantments;
    }

    @Override
    public boolean hasEnchantment(Holder<Enchantment> enchantment) {
        return this.enchantments.getLevel(enchantment) > 0;
    }

    @Override
    public int getEnchantmentLevel(Holder<Enchantment> enchantment) {
        if (this.hasEnchantment(enchantment)) {
            return this.enchantments.getLevel(enchantment);
        }
        return -1;
    }

    @Override
    public boolean hasEnchantment(TagKey<Enchantment> enchantmentTag) {
        for (Holder enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(this.level.registryAccess(), (Holder<Enchantment>)enchantment, enchantmentTag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getEnchantmentLevel(TagKey<Enchantment> enchantmentTag) {
        for (Holder enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(this.level.registryAccess(), (Holder<Enchantment>)enchantment, enchantmentTag)) continue;
            return this.enchantments.getLevel(enchantment);
        }
        return -1;
    }

    @Override
    public void setEnchantments(ItemEnchantments enchantments) {
        this.enchantments = enchantments;
    }

    @Override
    public boolean hideGlint() {
        return this.hideGlint;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.loadEnchantments(tag, registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveEnchantments(tag, registries);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        ItemEnchantments enchantments = (ItemEnchantments)componentInput.get(DataComponents.ENCHANTMENTS);
        if (enchantments != null) {
            this.enchantments = enchantments;
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(DataComponents.ENCHANTMENTS, (Object)this.getEnchantments());
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        CompoundTag tag = packet.getTag();
        if (tag != null) {
            this.handleUpdateTag(tag, registries);
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }

    public CompoundTag getPersistentData() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
        return tag;
    }

    public boolean isValidBlockState(BlockState state) {
        return this.getType().isValid(state);
    }
}

