/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.compat.jade;

import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.registries.DeferredHolder;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class JadeCompat
implements IWailaPlugin {
    public void register(IWailaCommonRegistration registration) {
    }

    public void registerClient(IWailaClientRegistration registration) {
        ArrayList blockClasses = new ArrayList();
        for (DeferredHolder registryObject : ModRegistry.BLOCKS.getEntries()) {
            Block block = (Block)registryObject.get();
            Class<?> blockClass2 = block.getClass();
            if (blockClasses.contains(blockClass2)) continue;
            blockClasses.add(blockClass2);
        }
        blockClasses.forEach(blockClass -> registration.registerBlockComponent((IComponentProvider)EnchantedBlockHandler.INSTANCE, blockClass));
    }

    public static class EnchantedBlockHandler
    implements IBlockComponentProvider {
        private static final ResourceLocation ENCHANTMENTS = ResourceLocation.fromNamespaceAndPath((String)"enchantableblocks", (String)"enchantments");
        public static final EnchantedBlockHandler INSTANCE = new EnchantedBlockHandler();

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            BlockEntity blockEntity = blockAccessor.getBlockEntity();
            if (blockEntity instanceof IEnchantable) {
                IEnchantable enchantable = (IEnchantable)blockEntity;
                Consumer<Component> consumer = arg_0 -> ((ITooltip)iTooltip).add(arg_0);
                enchantable.getEnchantments().addToTooltip(Item.TooltipContext.of((Level)blockAccessor.getLevel()), consumer, (TooltipFlag)TooltipFlag.NORMAL);
            }
        }

        public ResourceLocation getUid() {
            return ENCHANTMENTS;
        }
    }
}

