/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.mixin;

import com.mrbysco.enchantableblocks.block.blockentity.EnchantedDispenserBlockEntity;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.ProjectileDispenseBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ProjectileDispenseBehavior.class})
public abstract class AbstractProjectileDispenseBehaviorMixin
extends DefaultDispenseItemBehavior {
    @Shadow
    @Final
    private ProjectileItem projectileItem;
    @Shadow
    @Final
    private ProjectileItem.DispenseConfig dispenseConfig;

    @Inject(method={"execute(Lnet/minecraft/core/dispenser/BlockSource;Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")}, cancellable=true)
    public void enchantableblocks$execute(BlockSource source, ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        DispenserBlockEntity dispenserBlockEntity;
        if (stack.is(ItemTags.ARROWS) && (dispenserBlockEntity = source.blockEntity()) instanceof EnchantedDispenserBlockEntity) {
            EnchantedDispenserBlockEntity enchantedDispenserBlock = (EnchantedDispenserBlockEntity)dispenserBlockEntity;
            ServerLevel level = source.level();
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            Position position = this.dispenseConfig.positionFunction().getDispensePosition(source, direction);
            ItemStack cloneStack = stack.copy();
            enchantedDispenserBlock.getEnchantments().entrySet().forEach(entry -> {
                if (((Enchantment)((Holder)entry.getKey()).value()).canEnchant(cloneStack) && enchantedDispenserBlock.hasEnchantment((Holder<Enchantment>)((Holder)entry.getKey()))) {
                    cloneStack.enchant((Holder)entry.getKey(), enchantedDispenserBlock.getEnchantmentLevel((Holder<Enchantment>)((Holder)entry.getKey())));
                }
            });
            Projectile projectile = this.projectileItem.asProjectile((Level)level, position, cloneStack, direction);
            this.projectileItem.shoot(projectile, (double)direction.getStepX(), (double)direction.getStepY(), (double)direction.getStepZ(), this.dispenseConfig.power(), this.dispenseConfig.uncertainty());
            level.addFreshEntity((Entity)projectile);
            stack.shrink(1);
            cir.setReturnValue((Object)stack);
        }
    }
}

