/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block;

import com.mrbysco.enchantableblocks.block.blockentity.EnchantedChestBlockEntity;
import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.registry.ModMenus;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import com.mrbysco.enchantableblocks.util.MiscHelper;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class EnchantedChestBlock
extends AbstractChestBlock<EnchantedChestBlockEntity>
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    private static final Component CONTAINER_TITLE = Component.m_237115_((String)"container.chest");

    public EnchantedChestBlock(BlockBehaviour.Properties pProperties, Supplier<BlockEntityType<? extends EnchantedChestBlockEntity>> supplier) {
        super(pProperties, supplier);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public EnchantedChestBlock(BlockBehaviour.Properties properties) {
        super(properties, () -> ModRegistry.ENCHANTED_CHEST_BLOCK_ENTITY.get());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EnchantedChestBlockEntity(pos, state);
    }

    public DoubleBlockCombiner.NeighborCombineResult<? extends ChestBlockEntity> m_5641_(BlockState state, Level level, BlockPos pos, boolean override) {
        return DoubleBlockCombiner.Combiner::m_6502_;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof EnchantedChestBlockEntity) {
            EnchantedChestBlockEntity chestBlockEntity = (EnchantedChestBlockEntity)blockentity;
            int enchantmentLevel = chestBlockEntity.getEnchantmentLevel((Enchantment)ModEnchantments.STORING.get());
            if (enchantmentLevel < 1) {
                player.m_5893_((MenuProvider)new SimpleMenuProvider((theContainerID, theInventory, thePlayer) -> ChestMenu.m_39237_((int)theContainerID, (Inventory)theInventory, (Container)chestBlockEntity), CONTAINER_TITLE));
            } else if (enchantmentLevel == 1) {
                player.m_5893_((MenuProvider)new SimpleMenuProvider((theContainerID, theInventory, thePlayer) -> ModMenus.fourRows(theContainerID, theInventory, chestBlockEntity), CONTAINER_TITLE));
            } else if (enchantmentLevel == 2) {
                player.m_5893_((MenuProvider)new SimpleMenuProvider((theContainerID, theInventory, thePlayer) -> ModMenus.fiveRows(theContainerID, theInventory, chestBlockEntity), CONTAINER_TITLE));
            } else {
                player.m_5893_((MenuProvider)new SimpleMenuProvider((theContainerID, theInventory, thePlayer) -> ChestMenu.m_39246_((int)theContainerID, (Inventory)theInventory, (Container)chestBlockEntity), CONTAINER_TITLE));
            }
            player.m_36246_(this.getOpenChestStat());
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    protected Stat<ResourceLocation> getOpenChestStat() {
        return Stats.f_12988_.m_12902_((Object)Stats.f_12968_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? EnchantedChestBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModRegistry.ENCHANTED_CHEST_BLOCK_ENTITY.get()), EnchantedChestBlockEntity::lidAnimateTick) : null;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7357_(BlockState state, BlockGetter plevel, BlockPos pos, PathComputationType type) {
        return false;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof EnchantedChestBlockEntity) {
            EnchantedChestBlockEntity chestBlockEntity = (EnchantedChestBlockEntity)blockentity;
            chestBlockEntity.recheckOpen();
        }
    }

    public Item m_5456_() {
        return Items.f_42009_;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        IEnchantable blockEntity;
        ItemStack originalStack = new ItemStack((ItemLike)Blocks.f_50087_);
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (blockEntity2 instanceof IEnchantable && (blockEntity = (IEnchantable)blockEntity2).getEnchantmentsTag() != null) {
            originalStack.m_41784_().m_128365_("Enchantments", (Tag)blockEntity.getEnchantmentsTag());
        }
        return originalStack;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        IEnchantable enchantable;
        float explosionResistance = super.getExplosionResistance(state, level, pos, explosion);
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(Enchantments.f_44968_)) {
            int enchantmentLevel = enchantable.getEnchantmentLevel(Enchantments.f_44968_);
            explosionResistance *= (float)((enchantmentLevel + 1) * 30);
        }
        return explosionResistance;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        IEnchantable enchantable;
        BlockEntity blockentity = (BlockEntity)params.m_287261_(LootContextParams.f_81462_);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(Enchantments.f_44963_)) {
            return List.of();
        }
        return super.m_49635_(state, params);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof EnchantedChestBlockEntity) {
                EnchantedChestBlockEntity craftingTableBlockEntity = (EnchantedChestBlockEntity)blockentity;
                if (level instanceof ServerLevel && !craftingTableBlockEntity.hasEnchantment(Enchantments.f_44963_)) {
                    for (int i = 0; i < craftingTableBlockEntity.handler.getSlots(); ++i) {
                        MiscHelper.spawnItemStack(level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), craftingTableBlockEntity.handler.getStackInSlot(i));
                    }
                }
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof EnchantedChestBlockEntity) {
            EnchantedChestBlockEntity chestBlockEntity = (EnchantedChestBlockEntity)blockentity;
            chestBlockEntity.setCustomName(stack.m_41786_());
            chestBlockEntity.setEnchantments(stack.m_41785_());
        }
    }
}

