/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block.blockentity;

import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import com.mrbysco.enchantableblocks.util.TagHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class EnchantedCampfireBlockEntity
extends CampfireBlockEntity
implements IEnchantable {
    protected boolean hideGlint = false;
    protected ListTag enchantmentTag = null;
    protected final Object2IntMap<Enchantment> enchantments = new Object2IntOpenHashMap();

    public EnchantedCampfireBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public static void cookTick(Level level, BlockPos pos, BlockState state, EnchantedCampfireBlockEntity blockEntity) {
        boolean flag = false;
        for (int i = 0; i < blockEntity.f_59042_.size(); ++i) {
            SimpleContainer container;
            ItemStack resultStack;
            ItemStack inputStack = (ItemStack)blockEntity.f_59042_.get(i);
            if (inputStack.m_41619_()) continue;
            flag = true;
            int cookSpeed = 1;
            if (blockEntity.hasEnchantment((Enchantment)ModEnchantments.BOILING.get())) {
                int enchantmentLevel = blockEntity.getEnchantmentLevel((Enchantment)ModEnchantments.BOILING.get());
                cookSpeed += enchantmentLevel;
            }
            int n = i;
            blockEntity.f_59043_[n] = blockEntity.f_59043_[n] + cookSpeed;
            if (blockEntity.f_59043_[i] < blockEntity.f_59044_[i] || !(resultStack = blockEntity.f_222760_.m_213657_((Container)(container = new SimpleContainer(new ItemStack[]{inputStack})), level).map(arg_0 -> EnchantedCampfireBlockEntity.m_268985_((Container)container, level, arg_0)).orElse(inputStack)).m_246617_(level.m_246046_())) continue;
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)resultStack);
            blockEntity.f_59042_.set(i, (Object)ItemStack.f_41583_);
            level.m_7260_(pos, state, state, 3);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)state));
        }
        if (flag) {
            EnchantedCampfireBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void cooldownTick(Level level, BlockPos pos, BlockState state, EnchantedCampfireBlockEntity blockEntity) {
        boolean flag = false;
        for (int i = 0; i < blockEntity.f_59042_.size(); ++i) {
            if (blockEntity.f_59043_[i] <= 0) continue;
            flag = true;
            blockEntity.f_59043_[i] = Mth.m_14045_((int)(blockEntity.f_59043_[i] - 2), (int)0, (int)blockEntity.f_59044_[i]);
        }
        if (flag) {
            EnchantedCampfireBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void particleTick(Level level, BlockPos pos, BlockState state, EnchantedCampfireBlockEntity blockEntity) {
        RandomSource randomsource = level.f_46441_;
        if (randomsource.m_188501_() < 0.11f) {
            for (int i = 0; i < randomsource.m_188503_(2) + 2; ++i) {
                CampfireBlock.m_51251_((Level)level, (BlockPos)pos, (boolean)((Boolean)state.m_61143_((Property)CampfireBlock.f_51228_)), (boolean)false);
            }
        }
        int facing = ((Direction)state.m_61143_((Property)CampfireBlock.f_51230_)).m_122416_();
        for (int j = 0; j < blockEntity.f_59042_.size(); ++j) {
            if (((ItemStack)blockEntity.f_59042_.get(j)).m_41619_() || !(randomsource.m_188501_() < 0.2f)) continue;
            Direction direction = Direction.m_122407_((int)Math.floorMod(j + facing, 4));
            double d0 = (double)pos.m_123341_() + 0.5 - (double)((float)direction.m_122429_() * 0.3125f) + (double)((float)direction.m_122427_().m_122429_() * 0.3125f);
            double d1 = (double)pos.m_123342_() + 0.5;
            double d2 = (double)pos.m_123343_() + 0.5 - (double)((float)direction.m_122431_() * 0.3125f) + (double)((float)direction.m_122427_().m_122431_() * 0.3125f);
            for (int k = 0; k < 4; ++k) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)ModRegistry.ENCHANTED_CAMPFIRE_BLOCK_ENTITY.get();
    }

    @Override
    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    @Override
    public boolean hasEnchantment(Enchantment enchantment) {
        return this.enchantments.containsKey((Object)enchantment);
    }

    @Override
    public int getEnchantmentLevel(Enchantment enchantment) {
        if (this.hasEnchantment(enchantment)) {
            return this.enchantments.get((Object)enchantment);
        }
        return -1;
    }

    @Override
    public boolean hasEnchantment(TagKey<Enchantment> enchantmentTag) {
        for (Enchantment enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(enchantment, enchantmentTag)) continue;
            return true;
        }
        return this.enchantments.containsKey(enchantmentTag);
    }

    @Override
    public int getEnchantmentLevel(TagKey<Enchantment> enchantmentTag) {
        for (Enchantment enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(enchantment, enchantmentTag)) continue;
            return this.enchantments.get((Object)enchantment);
        }
        return -1;
    }

    @Override
    public void setEnchantments(ListTag enchantmentTags) {
        this.enchantmentTag = enchantmentTags;
        this.updateEnchantmentMap();
    }

    @Override
    public ListTag getEnchantmentsTag() {
        return this.enchantmentTag;
    }

    @Override
    public void updateEnchantmentMap() {
        this.enchantments.clear();
        if (this.enchantmentTag != null) {
            EnchantmentHelper.m_44882_((ListTag)this.enchantmentTag).forEach((enchantment, integer) -> {
                if (enchantment != null) {
                    this.enchantments.put(enchantment, integer);
                }
            });
            this.hideGlint = this.hasEnchantment((Enchantment)ModEnchantments.GLINTLESS.get());
        }
    }

    @Override
    public boolean hideGlint() {
        return this.hideGlint;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Enchantments")) {
            this.enchantmentTag = tag.m_128437_("Enchantments", 10);
            this.updateEnchantmentMap();
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.enchantmentTag != null) {
            tag.m_128365_("Enchantments", (Tag)this.enchantmentTag);
        }
    }

    public ClientboundBlockEntityDataPacket m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.m_131708_();
        if (tag != null) {
            this.handleUpdateTag(tag);
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public CompoundTag getPersistentData() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    private static /* synthetic */ ItemStack m_268985_(Container container, Level level, CampfireCookingRecipe recipe) {
        return recipe.m_5874_(container, level.m_9598_());
    }
}

