/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block.blockentity;

import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.mixin.ConduitBlockEntityAccessor;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import com.mrbysco.enchantableblocks.util.TagHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ConduitBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EnchantedConduitBlockEntity
extends ConduitBlockEntity
implements IEnchantable {
    protected boolean hideGlint = false;
    protected ListTag enchantmentTag = null;
    protected final Object2IntMap<Enchantment> enchantments = new Object2IntOpenHashMap();

    public EnchantedConduitBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, EnchantedConduitBlockEntity blockEntity) {
        ++blockEntity.f_59183_;
        long i = level.m_46467_();
        List effectBlocks = blockEntity.f_59188_;
        if (i % 40L == 0L) {
            boolean flag = ConduitBlockEntityAccessor.invokeUpdateShape(level, pos, effectBlocks);
            if (flag != blockEntity.f_59186_) {
                SoundEvent soundevent = flag ? SoundEvents.f_11767_ : SoundEvents.f_11824_;
                level.m_5594_((Player)null, pos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            blockEntity.f_59186_ = flag;
            ConduitBlockEntityAccessor.invokeUpdateHunting(blockEntity, effectBlocks);
            if (flag) {
                EnchantedConduitBlockEntity.applyEffects(level, pos, effectBlocks, blockEntity);
                EnchantedConduitBlockEntity.updateDestroyTarget(level, pos, state, effectBlocks, blockEntity);
            }
        }
        if (blockEntity.m_59216_()) {
            if (i % 80L == 0L) {
                level.m_5594_((Player)null, pos, SoundEvents.f_11768_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (i > blockEntity.f_59191_) {
                blockEntity.f_59191_ = i + 60L + (long)level.m_213780_().m_188503_(40);
                level.m_5594_((Player)null, pos, SoundEvents.f_11822_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private static void applyEffects(Level level, BlockPos pos, List<BlockPos> positions, EnchantedConduitBlockEntity blockEntity) {
        int zPos;
        int yPos;
        int xPos;
        AABB aabb;
        List players;
        boolean concealed = blockEntity.hasEnchantment((Enchantment)ModEnchantments.CONCEALED.get());
        int blockCount = positions.size();
        int range = blockCount / 7 * 16;
        if (blockEntity.hasEnchantment((Enchantment)ModEnchantments.RANGED.get())) {
            int enchantmentLevel = blockEntity.getEnchantmentLevel((Enchantment)ModEnchantments.RANGED.get());
            range *= (int)(1.0 + (double)enchantmentLevel * 0.5);
        }
        if (!(players = level.m_45976_(Player.class, aabb = new AABB((double)(xPos = pos.m_123341_()), (double)(yPos = pos.m_123342_()), (double)(zPos = pos.m_123343_()), (double)(xPos + 1), (double)(yPos + 1), (double)(zPos + 1)).m_82400_((double)range).m_82363_(0.0, (double)level.m_141928_(), 0.0))).isEmpty()) {
            for (Player player : players) {
                if (!pos.m_123314_((Vec3i)player.m_20183_(), (double)range) || !player.m_20070_()) continue;
                player.m_7292_(new MobEffectInstance(MobEffects.f_19592_, 260, 0, true, !concealed));
            }
        }
    }

    private static void updateDestroyTarget(Level level, BlockPos pos, BlockState state, List<BlockPos> positions, EnchantedConduitBlockEntity blockEntity) {
        LivingEntity livingentity = blockEntity.f_59189_;
        int blockCount = positions.size();
        if (blockCount < 42) {
            blockEntity.f_59189_ = null;
        } else if (blockEntity.f_59189_ == null && blockEntity.f_59190_ != null) {
            blockEntity.f_59189_ = ConduitBlockEntityAccessor.invokeFindDestroyTarget(level, pos, blockEntity.f_59190_);
            blockEntity.f_59190_ = null;
        } else if (blockEntity.f_59189_ == null) {
            List list = level.m_6443_(LivingEntity.class, ConduitBlockEntityAccessor.invokeGetDestroyRangeAABB(pos), livingEntity -> livingEntity instanceof Enemy && livingEntity.m_20070_());
            if (!list.isEmpty()) {
                blockEntity.f_59189_ = (LivingEntity)list.get(level.f_46441_.m_188503_(list.size()));
            }
        } else if (!blockEntity.f_59189_.m_6084_() || !pos.m_123314_((Vec3i)blockEntity.f_59189_.m_20183_(), 8.0)) {
            blockEntity.f_59189_ = null;
        }
        if (blockEntity.f_59189_ != null) {
            level.m_6263_((Player)null, blockEntity.f_59189_.m_20185_(), blockEntity.f_59189_.m_20186_(), blockEntity.f_59189_.m_20189_(), SoundEvents.f_11823_, SoundSource.BLOCKS, 1.0f, 1.0f);
            float damage = 4.0f;
            if (blockEntity.hasEnchantment(Enchantments.f_44977_)) {
                int enchantmentLevel = blockEntity.getEnchantmentLevel(Enchantments.f_44977_);
                damage += 1.0f + (float)Math.max(0, enchantmentLevel - 1) * 0.5f;
            }
            blockEntity.f_59189_.m_6469_(level.m_269111_().m_269425_(), damage);
        }
        if (livingentity != blockEntity.f_59189_) {
            level.m_7260_(pos, state, state, 2);
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, EnchantedConduitBlockEntity blockEntity) {
        ++blockEntity.f_59183_;
        long i = level.m_46467_();
        List list = blockEntity.f_59188_;
        if (i % 40L == 0L) {
            blockEntity.f_59186_ = ConduitBlockEntityAccessor.invokeUpdateShape(level, pos, list);
            ConduitBlockEntityAccessor.invokeUpdateHunting(blockEntity, list);
        }
        ConduitBlockEntityAccessor.invokeUpdateClientTarget(level, pos, blockEntity);
        EnchantedConduitBlockEntity.animationTick(blockEntity, level, pos, list, (Entity)blockEntity.f_59189_, blockEntity.f_59183_);
        if (blockEntity.m_59216_()) {
            blockEntity.f_59185_ += 1.0f;
        }
    }

    private static void animationTick(EnchantedConduitBlockEntity blockEntity, Level level, BlockPos pos, List<BlockPos> positions, @Nullable Entity entity, int tickCount) {
        if (blockEntity.hasEnchantment((Enchantment)ModEnchantments.CONCEALED.get())) {
            return;
        }
        RandomSource random = level.f_46441_;
        double d0 = Mth.m_14031_((float)((float)(tickCount + 35) * 0.1f)) / 2.0f + 0.5f;
        d0 = (d0 * d0 + d0) * (double)0.3f;
        Vec3 vec3 = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5 + d0, (double)pos.m_123343_() + 0.5);
        for (BlockPos blockpos : positions) {
            if (random.m_188503_(50) != 0) continue;
            BlockPos subtractPos = blockpos.m_121996_((Vec3i)pos);
            float f = -0.5f + random.m_188501_() + (float)subtractPos.m_123341_();
            float f1 = -2.0f + random.m_188501_() + (float)subtractPos.m_123342_();
            float f2 = -0.5f + random.m_188501_() + (float)subtractPos.m_123343_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123775_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (double)f, (double)f1, (double)f2);
        }
        if (entity != null) {
            Vec3 eyePos = new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
            float f3 = (-0.5f + random.m_188501_()) * (3.0f + entity.m_20205_());
            float f4 = -1.0f + random.m_188501_() * entity.m_20206_();
            float f5 = (-0.5f + random.m_188501_()) * (3.0f + entity.m_20205_());
            Vec3 vec32 = new Vec3((double)f3, (double)f4, (double)f5);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123775_, eyePos.f_82479_, eyePos.f_82480_, eyePos.f_82481_, vec32.f_82479_, vec32.f_82480_, vec32.f_82481_);
        }
    }

    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)ModRegistry.ENCHANTED_CONDUIT_BLOCK_ENTITY.get();
    }

    @Override
    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    @Override
    public boolean hasEnchantment(Enchantment enchantment) {
        return this.enchantments.containsKey((Object)enchantment);
    }

    @Override
    public int getEnchantmentLevel(Enchantment enchantment) {
        if (this.hasEnchantment(enchantment)) {
            return this.enchantments.get((Object)enchantment);
        }
        return -1;
    }

    @Override
    public boolean hasEnchantment(TagKey<Enchantment> enchantmentTag) {
        for (Enchantment enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(enchantment, enchantmentTag)) continue;
            return true;
        }
        return this.enchantments.containsKey(enchantmentTag);
    }

    @Override
    public int getEnchantmentLevel(TagKey<Enchantment> enchantmentTag) {
        for (Enchantment enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(enchantment, enchantmentTag)) continue;
            return this.enchantments.get((Object)enchantment);
        }
        return -1;
    }

    @Override
    public void setEnchantments(ListTag enchantmentTags) {
        this.enchantmentTag = enchantmentTags;
        this.updateEnchantmentMap();
    }

    @Override
    public ListTag getEnchantmentsTag() {
        return this.enchantmentTag;
    }

    @Override
    public void updateEnchantmentMap() {
        this.enchantments.clear();
        if (this.enchantmentTag != null) {
            EnchantmentHelper.m_44882_((ListTag)this.enchantmentTag).forEach((enchantment, integer) -> {
                if (enchantment != null) {
                    this.enchantments.put(enchantment, integer);
                }
            });
            this.hideGlint = this.hasEnchantment((Enchantment)ModEnchantments.GLINTLESS.get());
        }
    }

    @Override
    public boolean hideGlint() {
        return this.hideGlint;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Enchantments")) {
            this.enchantmentTag = tag.m_128437_("Enchantments", 10);
            this.updateEnchantmentMap();
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.enchantmentTag != null) {
            tag.m_128365_("Enchantments", (Tag)this.enchantmentTag);
        }
    }

    public ClientboundBlockEntityDataPacket m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.m_131708_();
        if (tag != null) {
            this.handleUpdateTag(tag);
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public CompoundTag getPersistentData() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }
}

