/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block.blockentity;

import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.mixin.HopperBlockEntityAccessor;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import com.mrbysco.enchantableblocks.util.TagHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

public class EnchantedHopperBlockEntity
extends HopperBlockEntity
implements IEnchantable {
    protected boolean hideGlint = false;
    protected ListTag enchantmentTag = null;
    protected final Object2IntMap<Enchantment> enchantments = new Object2IntOpenHashMap();

    public EnchantedHopperBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)ModRegistry.ENCHANTED_HOPPER_BLOCK_ENTITY.get();
    }

    public static void pushItemsTick(Level level, BlockPos pos, BlockState state, EnchantedHopperBlockEntity blockEntity) {
        int speed = 1;
        if (blockEntity.hasEnchantment((Enchantment)ModEnchantments.SPEED.get())) {
            speed = blockEntity.getEnchantmentLevel((Enchantment)ModEnchantments.SPEED.get()) + 1;
        }
        blockEntity.f_59302_ -= speed;
        blockEntity.f_59303_ = level.m_46467_();
        if (!((HopperBlockEntityAccessor)((Object)blockEntity)).invokeIsOnCooldown()) {
            int count = 1;
            if (blockEntity.hasEnchantment(Enchantments.f_44984_)) {
                int enchantmentLevel = Mth.m_14045_((int)blockEntity.getEnchantmentLevel(Enchantments.f_44984_), (int)0, (int)5);
                count = switch (enchantmentLevel) {
                    case 1 -> 4;
                    case 2 -> 8;
                    case 3 -> 16;
                    case 4 -> 32;
                    case 5 -> 64;
                    default -> count;
                };
            }
            blockEntity.m_59395_(0);
            int finalCount = count;
            EnchantedHopperBlockEntity.tryMoveItems(level, pos, state, blockEntity, () -> EnchantedHopperBlockEntity.suckInItems(level, blockEntity, finalCount));
        }
    }

    public static boolean suckInItems(Level level, EnchantedHopperBlockEntity hopper, int count) {
        Container container = EnchantedHopperBlockEntity.getSourceContainer(level, hopper);
        BlockEntity blockEntity = level.m_7702_(hopper.m_58899_().m_121945_(Direction.UP));
        if (blockEntity != null && blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN).isPresent()) {
            IItemHandler itemHandler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN).orElse(null);
            if (itemHandler != null) {
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack slotStack = itemHandler.getStackInSlot(i);
                    int actualCount = Math.clamp((int)count, (int)1, (int)slotStack.m_41613_());
                    ItemStack extractItem = itemHandler.extractItem(i, actualCount, true);
                    if (extractItem.m_41619_()) continue;
                    for (int j = 0; j < hopper.m_6643_(); ++j) {
                        ItemStack destStack = hopper.m_8020_(j);
                        if (!hopper.m_7013_(j, extractItem) || !destStack.m_41619_() && (destStack.m_41613_() >= destStack.m_41741_() || destStack.m_41613_() >= hopper.m_6893_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)extractItem, (ItemStack)destStack))) continue;
                        actualCount = Math.min((int)slotStack.m_41613_(), (int)Math.min((int)count, (int)(destStack.m_41741_() - destStack.m_41613_())));
                        extractItem = itemHandler.extractItem(i, actualCount, false);
                        if (destStack.m_41619_()) {
                            hopper.m_6836_(j, extractItem);
                        } else {
                            destStack.m_41769_(actualCount);
                            hopper.m_6836_(j, destStack);
                        }
                        hopper.m_6596_();
                        return true;
                    }
                }
                return false;
            }
            for (ItemEntity itementity : EnchantedHopperBlockEntity.m_155589_((Level)level, (Hopper)hopper)) {
                if (!EnchantedHopperBlockEntity.m_59331_((Container)hopper, (ItemEntity)itementity)) continue;
                return true;
            }
        } else {
            if (container != null) {
                Direction direction = Direction.DOWN;
                return EnchantedHopperBlockEntity.m_59397_(container, direction) ? false : EnchantedHopperBlockEntity.m_59339_(container, direction).anyMatch(p_59363_ -> EnchantedHopperBlockEntity.tryTakeInItemFromSlot(hopper, container, p_59363_, direction, count));
            }
            for (ItemEntity itementity : EnchantedHopperBlockEntity.m_155589_((Level)level, (Hopper)hopper)) {
                if (!EnchantedHopperBlockEntity.m_59331_((Container)hopper, (ItemEntity)itementity)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static Container getSourceContainer(Level pLevel, EnchantedHopperBlockEntity pHopper) {
        return EnchantedHopperBlockEntity.m_59347_(pLevel, pHopper.m_6343_(), pHopper.m_6358_() + 1.0, pHopper.m_6446_());
    }

    private static Container m_59347_(Level pLevel, double pX, double pY, double pZ) {
        List list;
        BlockEntity blockentity;
        WorldlyContainer container = null;
        BlockPos blockpos = BlockPos.m_274561_((double)pX, (double)pY, (double)pZ);
        BlockState blockstate = pLevel.m_8055_(blockpos);
        Block block = blockstate.m_60734_();
        if (block instanceof WorldlyContainerHolder) {
            container = ((WorldlyContainerHolder)block).m_5840_(blockstate, (LevelAccessor)pLevel, blockpos);
        } else if (blockstate.m_155947_() && (blockentity = pLevel.m_7702_(blockpos)) instanceof Container && (container = (Container)blockentity) instanceof ChestBlockEntity && block instanceof ChestBlock) {
            container = ChestBlock.m_51511_((ChestBlock)((ChestBlock)block), (BlockState)blockstate, (Level)pLevel, (BlockPos)blockpos, (boolean)true);
        }
        if (container == null && !(list = pLevel.m_6249_((Entity)null, new AABB(pX - 0.5, pY - 0.5, pZ - 0.5, pX + 0.5, pY + 0.5, pZ + 0.5), EntitySelector.f_20405_)).isEmpty()) {
            container = (Container)list.get(pLevel.f_46441_.m_188503_(list.size()));
        }
        return container;
    }

    private static boolean m_59397_(Container pContainer, Direction pDirection) {
        return EnchantedHopperBlockEntity.m_59339_(pContainer, pDirection).allMatch(slot -> pContainer.m_8020_(slot).m_41619_());
    }

    private static boolean tryTakeInItemFromSlot(EnchantedHopperBlockEntity pHopper, Container pContainer, int slot, Direction pDirection, int count) {
        ItemStack itemstack = pContainer.m_8020_(slot);
        if (!itemstack.m_41619_() && EnchantedHopperBlockEntity.m_271906_((Container)pHopper, pContainer, itemstack, slot, pDirection)) {
            ItemStack itemstack1 = itemstack.m_41777_();
            ItemStack itemstack2 = EnchantedHopperBlockEntity.m_59326_((Container)pContainer, (Container)pHopper, (ItemStack)pContainer.m_7407_(slot, Math.min((int)count, (int)itemstack1.m_41613_())), (Direction)null);
            if (itemstack2.m_41619_()) {
                pContainer.m_6596_();
                return true;
            }
            pContainer.m_6836_(slot, itemstack1);
        }
        return false;
    }

    private static boolean m_271906_(Container pSource, Container pDestination, ItemStack pStack, int pSlot, Direction pDirection) {
        WorldlyContainer worldlycontainer;
        if (!pDestination.m_271862_(pSource, pSlot, pStack)) {
            return false;
        }
        return !(pDestination instanceof WorldlyContainer) || (worldlycontainer = (WorldlyContainer)pDestination).m_7157_(pSlot, pStack, pDirection);
    }

    private static boolean tryMoveItems(Level level, BlockPos pos, BlockState state, EnchantedHopperBlockEntity blockEntity, BooleanSupplier validator) {
        if (!level.f_46443_ && !((HopperBlockEntityAccessor)((Object)blockEntity)).invokeIsOnCooldown() && ((Boolean)state.m_61143_((Property)HopperBlock.f_54022_)).booleanValue()) {
            boolean flag = false;
            if (!blockEntity.m_7983_()) {
                flag = EnchantedHopperBlockEntity.ejectItems(level, pos, state, blockEntity);
            }
            if (!((HopperBlockEntityAccessor)((Object)blockEntity)).invokeInventoryFull()) {
                flag |= validator.getAsBoolean();
            }
            if (flag) {
                blockEntity.m_59395_(8);
                EnchantedHopperBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                return true;
            }
        }
        return false;
    }

    private static boolean ejectItems(Level level, BlockPos pos, BlockState state, EnchantedHopperBlockEntity sourceContainer) {
        Direction direction;
        BlockEntity blockEntity;
        int count = 1;
        if (sourceContainer.hasEnchantment(Enchantments.f_44984_)) {
            int enchantmentLevel = Mth.m_14045_((int)sourceContainer.getEnchantmentLevel(Enchantments.f_44984_), (int)0, (int)5);
            switch (enchantmentLevel) {
                case 1: {
                    int n = 4;
                    break;
                }
                case 2: {
                    int n = 8;
                    break;
                }
                case 3: {
                    int n = 16;
                    break;
                }
                case 4: {
                    int n = 32;
                    break;
                }
                case 5: {
                    int n = 64;
                    break;
                }
                default: {
                    int n = count = count;
                }
            }
        }
        if ((blockEntity = level.m_7702_(pos.m_121945_(direction = (Direction)state.m_61143_((Property)HopperBlock.f_54021_)))) != null && blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).isPresent()) {
            IItemHandler itemHandler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).orElse(null);
            if (!EnchantedHopperBlockEntity.isFull(itemHandler)) {
                for (int i = 0; i < sourceContainer.m_6643_(); ++i) {
                    if (sourceContainer.m_8020_(i).m_41619_()) continue;
                    ItemStack originalSlotContents = sourceContainer.m_8020_(i).m_41777_();
                    ItemStack insertStack = sourceContainer.m_7407_(i, Math.min((int)count, (int)originalSlotContents.m_41613_()));
                    ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)insertStack, (boolean)false);
                    if (remainder.m_41619_()) {
                        return true;
                    }
                    int extractedAmount = insertStack.m_41613_() - remainder.m_41613_();
                    originalSlotContents.m_41774_(extractedAmount);
                    sourceContainer.m_6836_(i, originalSlotContents);
                }
            }
            return false;
        }
        Container container = EnchantedHopperBlockEntity.m_155592_(level, pos, state);
        if (container != null && !EnchantedHopperBlockEntity.m_59385_(container, direction)) {
            for (int i = 0; i < sourceContainer.m_6643_(); ++i) {
                if (sourceContainer.m_8020_(i).m_41619_()) continue;
                ItemStack stackCopy = sourceContainer.m_8020_(i).m_41777_();
                ItemStack addStack = EnchantedHopperBlockEntity.m_59326_((Container)sourceContainer, (Container)container, (ItemStack)sourceContainer.m_7407_(i, Math.min((int)count, (int)stackCopy.m_41613_())), (Direction)direction);
                if (addStack.m_41619_()) {
                    container.m_6596_();
                    return true;
                }
                sourceContainer.m_6836_(i, stackCopy);
            }
        }
        return false;
    }

    private static boolean isFull(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (!stackInSlot.m_41619_() && stackInSlot.m_41613_() >= itemHandler.getSlotLimit(slot)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static Container m_155592_(Level pLevel, BlockPos pPos, BlockState pState) {
        Direction direction = (Direction)pState.m_61143_((Property)HopperBlock.f_54021_);
        return EnchantedHopperBlockEntity.m_59390_((Level)pLevel, (BlockPos)pPos.m_121945_(direction));
    }

    private static boolean m_59385_(Container container, Direction direction) {
        return EnchantedHopperBlockEntity.m_59339_(container, direction).allMatch(p_59379_ -> {
            ItemStack itemstack = container.m_8020_(p_59379_);
            return itemstack.m_41613_() >= itemstack.m_41741_();
        });
    }

    private static IntStream m_59339_(Container pContainer, Direction pDirection) {
        return pContainer instanceof WorldlyContainer ? IntStream.of(((WorldlyContainer)pContainer).m_7071_(pDirection)) : IntStream.range(0, pContainer.m_6643_());
    }

    private static IntStream getSlots(IItemHandler itemHandler) {
        return IntStream.range(0, itemHandler.getSlots());
    }

    @Override
    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    @Override
    public boolean hasEnchantment(Enchantment enchantment) {
        return this.enchantments.containsKey((Object)enchantment);
    }

    @Override
    public int getEnchantmentLevel(Enchantment enchantment) {
        if (this.hasEnchantment(enchantment)) {
            return this.enchantments.get((Object)enchantment);
        }
        return -1;
    }

    @Override
    public boolean hasEnchantment(TagKey<Enchantment> enchantmentTag) {
        for (Enchantment enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(enchantment, enchantmentTag)) continue;
            return true;
        }
        return this.enchantments.containsKey(enchantmentTag);
    }

    @Override
    public int getEnchantmentLevel(TagKey<Enchantment> enchantmentTag) {
        for (Enchantment enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(enchantment, enchantmentTag)) continue;
            return this.enchantments.get((Object)enchantment);
        }
        return -1;
    }

    @Override
    public void setEnchantments(ListTag enchantmentTags) {
        this.enchantmentTag = enchantmentTags;
        this.updateEnchantmentMap();
    }

    @Override
    public ListTag getEnchantmentsTag() {
        return this.enchantmentTag;
    }

    @Override
    public void updateEnchantmentMap() {
        this.enchantments.clear();
        if (this.enchantmentTag != null) {
            EnchantmentHelper.m_44882_((ListTag)this.enchantmentTag).forEach((enchantment, integer) -> {
                if (enchantment != null) {
                    this.enchantments.put(enchantment, integer);
                }
            });
            this.hideGlint = this.hasEnchantment((Enchantment)ModEnchantments.GLINTLESS.get());
        }
    }

    @Override
    public boolean hideGlint() {
        return this.hideGlint;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Enchantments")) {
            this.enchantmentTag = tag.m_128437_("Enchantments", 10);
            this.updateEnchantmentMap();
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.enchantmentTag != null) {
            tag.m_128365_("Enchantments", (Tag)this.enchantmentTag);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.m_131708_();
        if (tag != null) {
            this.handleUpdateTag(tag);
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public CompoundTag getPersistentData() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }
}

