/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.math.Axis;
import com.mrbysco.enchantableblocks.block.EnchantedChestBlock;
import com.mrbysco.enchantableblocks.block.blockentity.EnchantedTrappedChestBlockEntity;
import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.client.CustomRenderType;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Calendar;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class EnchantedChestRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static final String BOTTOM = "bottom";
    private static final String LID = "lid";
    private static final String LOCK = "lock";
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;
    private boolean xmasTextures;
    private boolean renderEnchantment = true;

    public EnchantedChestRenderer(BlockEntityRendererProvider.Context context) {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.xmasTextures = true;
        }
        ModelPart modelpart = context.m_173582_(ModelLayers.f_171275_);
        this.bottom = modelpart.m_171324_(BOTTOM);
        this.lid = modelpart.m_171324_(LID);
        this.lock = modelpart.m_171324_(LOCK);
    }

    public void m_6922_(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level;
        boolean flag;
        BlockState state;
        Block block;
        if (blockEntity.m_58904_() == null) {
            return;
        }
        if (blockEntity instanceof IEnchantable) {
            IEnchantable enchantable = (IEnchantable)blockEntity;
            this.renderEnchantment = !enchantable.hideGlint();
        }
        if ((block = (state = (flag = (level = blockEntity.m_58904_()) != null) ? blockEntity.m_58900_() : (BlockState)((Block)ModRegistry.ENCHANTED_CHEST.get()).m_49966_().m_61124_((Property)EnchantedChestBlock.FACING, (Comparable)Direction.SOUTH)).m_60734_()) instanceof AbstractChestBlock) {
            poseStack.m_85836_();
            float yRot = ((Direction)state.m_61143_((Property)EnchantedChestBlock.FACING)).m_122435_();
            poseStack.m_252880_(0.5f, 0.5f, 0.5f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-yRot));
            poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
            DoubleBlockCombiner.NeighborCombineResult result = DoubleBlockCombiner.Combiner::m_6502_;
            float f1 = ((Float2FloatFunction)result.m_5649_(ChestBlock.m_51517_((LidBlockEntity)((LidBlockEntity)blockEntity)))).get(partialTick);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)result.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(packedLight);
            Material material = this.getMaterial(blockEntity);
            PoseStack.Pose pose = poseStack.m_85850_();
            VertexConsumer vertexconsumer = this.renderEnchantment ? VertexMultiConsumer.m_86168_((VertexConsumer)new SheetedDecalTextureGenerator(bufferSource.m_6299_(CustomRenderType.GLINT), pose.m_252922_(), pose.m_252943_(), 0.0078125f), (VertexConsumer)material.m_119194_(bufferSource, RenderType::m_110452_)) : material.m_119194_(bufferSource, RenderType::m_110452_);
            this.render(poseStack, vertexconsumer, this.lid, this.lock, this.bottom, f1, i, packedOverlay);
            poseStack.m_85849_();
        }
    }

    private void render(PoseStack poseStack, VertexConsumer consumer, ModelPart lidPart, ModelPart lockPart, ModelPart bottomPart, float pLidAngle, int packedLight, int pPackedOverlay) {
        lockPart.f_104203_ = lidPart.f_104203_ = -(pLidAngle * 1.5707964f);
        lidPart.m_104301_(poseStack, consumer, packedLight, pPackedOverlay);
        lockPart.m_104301_(poseStack, consumer, packedLight, pPackedOverlay);
        bottomPart.m_104301_(poseStack, consumer, packedLight, pPackedOverlay);
    }

    protected Material getMaterial(T blockEntity) {
        if (this.xmasTextures) {
            return Sheets.f_110748_;
        }
        return blockEntity instanceof EnchantedTrappedChestBlockEntity ? Sheets.f_110745_ : Sheets.f_110751_;
    }
}

