/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.datagen.data;

import com.mrbysco.enchantableblocks.lootfunctions.CopyEnchantmentsFunction;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyBlockState;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.RegistryObject;

public class EnchantableLootProvider
extends LootTableProvider {
    public EnchantableLootProvider(PackOutput packOutput) {
        super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(EnchantableBlockLootSubProvider::new, LootContextParamSets.f_81421_)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationContext validationContext) {
        map.forEach((location, lootTable) -> lootTable.m_79136_(validationContext));
    }

    private static class EnchantableBlockLootSubProvider
    extends BlockLootSubProvider {
        protected EnchantableBlockLootSubProvider() {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_());
        }

        protected void m_245660_() {
            this.m_246481_((Block)ModRegistry.ENCHANTED_FURNACE.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.f_50094_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_BLAST_FURNACE.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.f_50620_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_SMOKER.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.f_50619_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_BEACON.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.f_50273_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_CAMPFIRE.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.f_50683_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_SOUL_CAMPFIRE.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.f_50684_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_MAGMA_BLOCK.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.f_50450_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_DISPENSER.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.f_50061_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_RESPAWN_ANCHOR.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.f_50724_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_HOPPER.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.f_50332_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_ENCHANTING_TABLE.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.f_50201_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_CONDUIT.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.f_50569_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_CRAFTING_TABLE.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.f_50091_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_BEEHIVE.get(), block -> EnchantableBlockLootSubProvider.createEnchantedBeeHiveDrop(block, Blocks.f_50718_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_CHEST.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.f_50087_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_TRAPPED_CHEST.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.f_50325_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_WHITE_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.f_50066_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_ORANGE_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.f_50067_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_MAGENTA_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.f_50068_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_LIGHT_BLUE_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.f_50017_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_YELLOW_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.f_50018_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_LIME_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.f_50019_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_PINK_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.f_50020_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_GRAY_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.f_50021_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_LIGHT_GRAY_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.f_50022_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_CYAN_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.f_50023_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_PURPLE_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.f_50024_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_BLUE_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.f_50025_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_BROWN_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.f_50026_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_GREEN_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.f_50027_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_RED_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.f_50028_));
            this.m_246481_((Block)ModRegistry.ENCHANTED_BLACK_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.f_50029_));
        }

        protected static LootTable.Builder createEnchantedBeeHiveDrop(Block block, Block originalBlock) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)originalBlock).m_79080_(f_243678_)).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Bees", "BlockEntityTag.Bees")).m_79078_((LootItemFunction.Builder)CopyBlockState.m_80062_((Block)block).m_80084_((Property)BeehiveBlock.f_49564_)).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_(CopyEnchantmentsFunction.copyEnchantments()).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)originalBlock))));
        }

        protected LootTable.Builder createEnchantableBedBlockTable(Block block, Block originalBlock) {
            return LootTable.m_79147_().m_79161_((LootPool.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)originalBlock).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD)))).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_(CopyEnchantmentsFunction.copyEnchantments()))));
        }

        protected LootTable.Builder createEnchantableBlockEntityTable(Block block, Block originalBlock) {
            return LootTable.m_79147_().m_79161_((LootPool.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)originalBlock).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_(CopyEnchantmentsFunction.copyEnchantments()))));
        }

        protected Iterable<Block> getKnownBlocks() {
            return ModRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
        }
    }
}

