/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.blocks;

import cn.foggyhillside.festival_delicacies.blocks.entities.ChoppingBlockEntity;
import cn.foggyhillside.festival_delicacies.recipe.ChoppingRecipe;
import cn.foggyhillside.festival_delicacies.registry.ModBlockStateProperties;
import cn.foggyhillside.festival_delicacies.registry.ModSounds;
import cn.foggyhillside.festival_delicacies.registry.ModTags;
import cn.foggyhillside.festival_delicacies.util.Utils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ChoppingBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty KNIFE_INSERTED = ModBlockStateProperties.KNIFE_INSERTED;
    public static final BooleanProperty WITH_KNIFE = ModBlockStateProperties.WITH_KNIFE;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0);

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)KNIFE_INSERTED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WITH_KNIFE, (Comparable)Boolean.valueOf(false));
    }

    public ChoppingBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)KNIFE_INSERTED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WITH_KNIFE, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{KNIFE_INSERTED});
        builder.m_61104_(new Property[]{WITH_KNIFE});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new ChoppingBlockEntity(pPos, pState);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (pState.m_60734_() != pNewState.m_60734_()) {
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof ChoppingBlockEntity) {
                ChoppingBlockEntity choppingBlock = (ChoppingBlockEntity)blockEntity;
                Containers.m_18992_((Level)pLevel, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (ItemStack)choppingBlock.getItemStack());
                pLevel.m_46717_(pPos, (Block)this);
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
        }
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        ChoppingBlockEntity choppingBlockEntity;
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof ChoppingBlockEntity && !(choppingBlockEntity = (ChoppingBlockEntity)blockEntity).getItemStack().m_41619_()) {
            return 15;
        }
        return 0;
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        BlockState newState = super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof ChoppingBlockEntity) {
            ChoppingBlockEntity entity = (ChoppingBlockEntity)blockEntity;
            if (entity.getItemStack().m_41619_() && ((Boolean)newState.m_61143_((Property)WITH_KNIFE)).booleanValue()) {
                return (BlockState)newState.m_61124_((Property)WITH_KNIFE, (Comparable)Boolean.valueOf(false));
            }
            if (!entity.getItemStack().m_41619_() && !((Boolean)pState.m_61143_((Property)WITH_KNIFE)).booleanValue()) {
                return (BlockState)newState.m_61124_((Property)WITH_KNIFE, (Comparable)Boolean.valueOf(true));
            }
        }
        return newState;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack heldStack = pPlayer.m_21120_(pHand);
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        Direction direction = ((Direction)pState.m_61143_((Property)FACING)).m_122428_();
        if (blockEntity instanceof ChoppingBlockEntity) {
            ChoppingBlockEntity choppingBlockEntity = (ChoppingBlockEntity)blockEntity;
            if (choppingBlockEntity.getItemStack().m_41619_()) {
                if (ChoppingBlock.isKnife(heldStack) && choppingBlockEntity.addItem(heldStack, pPlayer)) {
                    pLevel.m_6263_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)WITH_KNIFE, (Comparable)Boolean.valueOf(true)));
                    return InteractionResult.SUCCESS;
                }
            } else if (heldStack.m_41619_()) {
                if (pPlayer.m_6144_()) {
                    pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)KNIFE_INSERTED, (Comparable)Boolean.valueOf((Boolean)pState.m_61143_((Property)KNIFE_INSERTED) == false)));
                    return InteractionResult.SUCCESS;
                }
                if (pHand.equals((Object)InteractionHand.MAIN_HAND) && choppingBlockEntity.extractItem(pPlayer, pHand)) {
                    pLevel.m_6263_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), SoundEvents.f_12630_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)WITH_KNIFE, (Comparable)Boolean.valueOf(false)));
                    return InteractionResult.SUCCESS;
                }
            } else if (!pPlayer.m_6144_()) {
                SimpleContainer container = new SimpleContainer(new ItemStack[]{heldStack.m_41777_()});
                Optional recipe = pLevel.m_7465_().m_44015_((RecipeType)ChoppingRecipe.Type.INSTANCE, (Container)container, pLevel);
                if (recipe.isPresent()) {
                    NonNullList<ItemStack> list = ((ChoppingRecipe)recipe.get()).getResultsList();
                    pLevel.m_6263_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (SoundEvent)ModSounds.CHOP.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    ChoppingBlock.spawnChoppingParticles(pLevel, pPos, heldStack);
                    if (!pPlayer.m_7500_()) {
                        heldStack.m_41774_(1);
                        choppingBlockEntity.itemHurt(pLevel, pPos);
                    }
                    for (ItemStack stack : list) {
                        Utils.dropItem(pLevel, stack.m_41620_(stack.m_41613_()), (float)pPos.m_123341_() + 0.5f, (float)pPos.m_123342_() + 0.3f, (float)pPos.m_123343_() + 0.5f, (float)direction.m_122429_() * 0.2f, 0.0, (float)direction.m_122431_() * 0.2f);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (!pLevel.m_5776_()) {
                    pPlayer.m_5661_((Component)Component.m_237115_((String)"%s.%s".formatted("festival_delicacies", "client_message.cannot_chop")), true);
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public static void spawnChoppingParticles(Level level, BlockPos pos, ItemStack stack) {
        Vec3 vec3d = new Vec3(((double)level.f_46441_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)level.f_46441_.m_188501_() - 0.5) * 0.1);
        if (level instanceof ServerLevel) {
            ((ServerLevel)level).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.4f), (double)((float)pos.m_123343_() + 0.5f), 1, vec3d.f_82479_, vec3d.f_82480_ + 0.05, vec3d.f_82481_, 0.0);
        } else {
            level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.4f), (double)((float)pos.m_123343_() + 0.5f), vec3d.f_82479_, vec3d.f_82480_ + 0.05, vec3d.f_82481_);
        }
    }

    public static boolean isKnife(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41763_() && stack.m_204117_(ModTags.KNIFE);
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 30;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 30;
    }
}

